/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class JBMovePanel
extends JBPanel {
    public static final String MOVE_PANEL_PLACE = "MOVE_PANEL";
    public static final InsertPositionStrategy ANCHORING_SELECTION = new InsertPositionStrategy(){

        @Override
        public int getInsertionIndex(@NotNull Object data, @NotNull JList list2) {
            if (data == null) {
                1.$$$reportNull$$$0(0);
            }
            if (list2 == null) {
                1.$$$reportNull$$$0(1);
            }
            int index = list2.getSelectedIndex();
            DefaultListModel model = (DefaultListModel)list2.getModel();
            return index < 0 ? model.getSize() : index + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/components/JBMovePanel$1";
            objectArray[2] = "getInsertionIndex";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertPositionStrategy NATURAL_ORDER = new InsertPositionStrategy(){

        @Override
        public int getInsertionIndex(@NotNull Object data, @NotNull JList list2) {
            Object e;
            if (data == null) {
                2.$$$reportNull$$$0(0);
            }
            if (list2 == null) {
                2.$$$reportNull$$$0(1);
            }
            Enumeration elements = ((DefaultListModel)list2.getModel()).elements();
            int index = 0;
            while (elements.hasMoreElements() && ((Comparable)(e = elements.nextElement())).compareTo(data) < 0) {
                ++index;
            }
            return index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/components/JBMovePanel$2";
            objectArray[2] = "getInsertionIndex";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    private final Map<ButtonType, ActionButton> myButtons;
    @NotNull
    private final ListPanel myLeftPanel;
    @NotNull
    private final ListPanel myRightPanel;
    @NotNull
    protected final JList myLeftList;
    @NotNull
    protected final JList myRightList;
    @NotNull
    protected final ActionButton myLeftButton;
    @NotNull
    protected final ActionButton myAllLeftButton;
    @NotNull
    protected final ActionButton myRightButton;
    @NotNull
    protected final ActionButton myAllRightButton;
    @NotNull
    protected final ActionButton myUpButton;
    @NotNull
    protected final ActionButton myDownButton;
    @NotNull
    private InsertPositionStrategy myLeftInsertionStrategy;
    @NotNull
    private InsertPositionStrategy myRightInsertionStrategy;
    private boolean myActivePreferredSizeProcessing;

    public JBMovePanel(@NotNull JList left, @NotNull JList right) {
        if (left == null) {
            JBMovePanel.$$$reportNull$$$0(0);
        }
        if (right == null) {
            JBMovePanel.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new GridBagLayout());
        this.myButtons = new EnumMap<ButtonType, ActionButton>(ButtonType.class);
        this.myLeftPanel = new ListPanel();
        this.myRightPanel = new ListPanel();
        this.myLeftInsertionStrategy = ANCHORING_SELECTION;
        this.myRightInsertionStrategy = ANCHORING_SELECTION;
        JBMovePanel.assertModelIsEditable(left);
        JBMovePanel.assertModelIsEditable(right);
        this.myLeftList = left;
        this.myRightList = right;
        JPanel leftRightButtonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1));
        this.myRightButton = this.createButton(ButtonType.RIGHT);
        leftRightButtonsPanel.add(this.myRightButton);
        this.myAllRightButton = this.createButton(ButtonType.ALL_RIGHT);
        leftRightButtonsPanel.add(this.myAllRightButton);
        this.myLeftButton = this.createButton(ButtonType.LEFT);
        leftRightButtonsPanel.add(this.myLeftButton);
        this.myAllLeftButton = this.createButton(ButtonType.ALL_LEFT);
        leftRightButtonsPanel.add(this.myAllLeftButton);
        this.myUpButton = JBMovePanel.createButton(new UpAction());
        this.myDownButton = JBMovePanel.createButton(new DownAction());
        JPanel upDownButtonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1));
        upDownButtonsPanel.add(this.myUpButton);
        upDownButtonsPanel.add(this.myDownButton);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2 || e.getButton() != 1) {
                    return;
                }
                if (e.getSource() == JBMovePanel.this.myLeftList) {
                    JBMovePanel.this.doRight();
                } else if (e.getSource() == JBMovePanel.this.myRightList) {
                    JBMovePanel.this.doLeft();
                }
            }
        };
        this.myLeftList.addMouseListener(mouseListener);
        this.myRightList.addMouseListener(mouseListener);
        GridBag listConstraints = new GridBag().weightx(1.0).weighty(1.0).fillCell();
        GridBag buttonConstraints = new GridBag().anchor(10);
        this.myLeftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)left), listConstraints);
        this.add(this.myLeftPanel, listConstraints);
        this.add(leftRightButtonsPanel, buttonConstraints);
        this.myRightPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)right), listConstraints);
        this.add(this.myRightPanel, listConstraints);
        this.add(upDownButtonsPanel, buttonConstraints);
    }

    private static void assertModelIsEditable(@NotNull JList list2) {
        if (list2 == null) {
            JBMovePanel.$$$reportNull$$$0(2);
        }
        assert (list2.getModel() instanceof DefaultListModel) : String.format("List model should extends %s interface", DefaultListModel.class.getName());
    }

    public void setShowButtons(ButtonType ... types) {
        if (types == null) {
            JBMovePanel.$$$reportNull$$$0(3);
        }
        for (ActionButton button : this.myButtons.values()) {
            button.setVisible(false);
        }
        for (ButtonType type2 : types) {
            this.myButtons.get((Object)type2).setVisible(true);
        }
    }

    public void setListLabels(@NotNull String left, @NotNull String right) {
        if (left == null) {
            JBMovePanel.$$$reportNull$$$0(4);
        }
        if (right == null) {
            JBMovePanel.$$$reportNull$$$0(5);
        }
        Insets insets = new Insets(7, 0, 0, 0);
        this.myLeftPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)left, (boolean)false, (Insets)insets));
        this.myRightPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)right, (boolean)false, (Insets)insets));
    }

    public void setLeftInsertionStrategy(@NotNull InsertPositionStrategy leftInsertionStrategy) {
        if (leftInsertionStrategy == null) {
            JBMovePanel.$$$reportNull$$$0(6);
        }
        this.myLeftInsertionStrategy = leftInsertionStrategy;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myLeftList.setEnabled(enabled);
        this.myRightList.setEnabled(enabled);
        for (ActionButton button : this.myButtons.values()) {
            button.setEnabled(enabled);
        }
    }

    @NotNull
    private ActionButton createButton(@NotNull ButtonType type2) {
        AnAction action;
        if (type2 == null) {
            JBMovePanel.$$$reportNull$$$0(7);
        }
        switch (type2) {
            case LEFT: {
                action = new LeftAction();
                break;
            }
            case RIGHT: {
                action = new RightAction();
                break;
            }
            case ALL_LEFT: {
                action = new AllLeftAction();
                break;
            }
            case ALL_RIGHT: {
                action = new AllRightAction();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported button type: " + (Object)((Object)type2));
            }
        }
        ActionButton button = JBMovePanel.createButton(action);
        this.myButtons.put(type2, button);
        ActionButton actionButton = button;
        if (actionButton == null) {
            JBMovePanel.$$$reportNull$$$0(8);
        }
        return actionButton;
    }

    @NotNull
    private static ActionButton createButton(@NotNull AnAction action) {
        if (action == null) {
            JBMovePanel.$$$reportNull$$$0(9);
        }
        PresentationFactory presentationFactory = new PresentationFactory();
        Icon icon = AllIcons.Actions.AllLeft;
        Dimension size = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        ActionButton actionButton = new ActionButton(action, presentationFactory.getPresentation(action), MOVE_PANEL_PLACE, size);
        if (actionButton == null) {
            JBMovePanel.$$$reportNull$$$0(10);
        }
        return actionButton;
    }

    protected void doRight() {
        JBMovePanel.moveBetween(this.myRightList, this.myRightInsertionStrategy, this.myLeftList);
    }

    protected void doLeft() {
        JBMovePanel.moveBetween(this.myLeftList, this.myLeftInsertionStrategy, this.myRightList);
    }

    protected void doAllLeft() {
        JBMovePanel.moveAllBetween(this.myLeftList, this.myRightList);
    }

    protected void doAllRight() {
        JBMovePanel.moveAllBetween(this.myRightList, this.myLeftList);
    }

    private static void moveBetween(@NotNull JList to, @NotNull InsertPositionStrategy strategy, @NotNull JList from) {
        int[] indices2;
        if (to == null) {
            JBMovePanel.$$$reportNull$$$0(11);
        }
        if (strategy == null) {
            JBMovePanel.$$$reportNull$$$0(12);
        }
        if (from == null) {
            JBMovePanel.$$$reportNull$$$0(13);
        }
        if ((indices2 = from.getSelectedIndices()).length <= 0) {
            return;
        }
        Object[] values = from.getSelectedValues();
        for (int i = indices2.length - 1; i >= 0; --i) {
            ((DefaultListModel)from.getModel()).remove(indices2[i]);
        }
        if (from.getModel().getSize() > 0) {
            int newSelectionIndex = indices2[0];
            newSelectionIndex = Math.min(from.getModel().getSize() - 1, newSelectionIndex);
            from.setSelectedIndex(newSelectionIndex);
        }
        to.clearSelection();
        DefaultListModel toModel = (DefaultListModel)to.getModel();
        int newSelectionIndex = -1;
        for (Object value2 : values) {
            if (toModel.contains(value2)) continue;
            int i = strategy.getInsertionIndex(value2, to);
            if (newSelectionIndex < 0) {
                newSelectionIndex = i;
            }
            toModel.add(i, value2);
            to.addSelectionInterval(i, i);
        }
    }

    private static void moveAllBetween(@NotNull JList to, @NotNull JList from) {
        if (to == null) {
            JBMovePanel.$$$reportNull$$$0(14);
        }
        if (from == null) {
            JBMovePanel.$$$reportNull$$$0(15);
        }
        DefaultListModel fromModel = (DefaultListModel)from.getModel();
        DefaultListModel toModel = (DefaultListModel)to.getModel();
        while (fromModel.getSize() > 0) {
            Object element = fromModel.remove(0);
            if (toModel.contains(element)) continue;
            toModel.addElement(element);
        }
    }

    public static void main(String[] args) {
        JBMovePanel panel2 = new JBMovePanel((JList)new JBList(new Object[]{"asdas", "weqrwe", "ads12312", "aZSD23"}), (JList)new JBList(new Object[]{"123412", "as2341", "aaaaaaaaaaa", "ZZZZZZZZZZ", "12"}));
        JFrame test = new JFrame("Test");
        test.setContentPane((Container)((Object)panel2));
        test.setSize(500, 500);
        test.setDefaultCloseOperation(3);
        test.setVisible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftInsertionStrategy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBMovePanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBMovePanel";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertModelIsEditable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setShowButtons";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setListLabels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLeftInsertionStrategy";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createButton";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveBetween";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moveAllBetween";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DownAction
    extends AnAction {
        DownAction() {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Down);
        }

        public void actionPerformed(AnActionEvent e) {
            ListUtil.moveSelectedItemsDown((JList)JBMovePanel.this.myRightList);
        }
    }

    private class UpAction
    extends AnAction {
        UpAction() {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.UP);
        }

        public void actionPerformed(AnActionEvent e) {
            ListUtil.moveSelectedItemsUp((JList)JBMovePanel.this.myRightList);
        }
    }

    private class AllRightAction
    extends AnAction {
        AllRightAction() {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.AllRight);
        }

        public void actionPerformed(AnActionEvent e) {
            JBMovePanel.this.doAllRight();
        }
    }

    private class AllLeftAction
    extends AnAction {
        AllLeftAction() {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.AllLeft);
        }

        public void actionPerformed(AnActionEvent e) {
            JBMovePanel.this.doAllLeft();
        }
    }

    private class RightAction
    extends AnAction {
        RightAction() {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Right);
        }

        public void actionPerformed(AnActionEvent e) {
            JBMovePanel.this.doRight();
        }
    }

    private class LeftAction
    extends AnAction {
        LeftAction() {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Left);
        }

        public void actionPerformed(AnActionEvent e) {
            JBMovePanel.this.doLeft();
        }
    }

    private class ListPanel
    extends JPanel {
        ListPanel() {
            super(new GridBagLayout());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension getPreferredSize() {
            Dimension d1 = super.getPreferredSize();
            if (JBMovePanel.this.myActivePreferredSizeProcessing) {
                return d1;
            }
            JBMovePanel.this.myActivePreferredSizeProcessing = true;
            try {
                Dimension d2 = JBMovePanel.this.myLeftPanel == this ? JBMovePanel.this.myRightPanel.getPreferredSize() : JBMovePanel.this.myLeftPanel.getPreferredSize();
                Dimension dimension = new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
                return dimension;
            }
            finally {
                JBMovePanel.this.myActivePreferredSizeProcessing = false;
            }
        }
    }

    public static interface InsertPositionStrategy {
        public int getInsertionIndex(@NotNull Object var1, @NotNull JList var2);
    }

    public static enum ButtonType {
        LEFT,
        RIGHT,
        ALL_LEFT,
        ALL_RIGHT;

    }
}

