/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TabbedContentImpl
extends ContentImpl
implements TabbedContent {
    private final List<Pair<String, JComponent>> myTabs = new ArrayList<Pair<String, JComponent>>();
    private String myPrefix;

    public TabbedContentImpl(JComponent component, String displayName, boolean isPinnable, String titlePrefix) {
        super(component, displayName, isPinnable);
        this.myPrefix = titlePrefix;
        this.addContent(component, displayName, true);
    }

    public void addContent(@NotNull JComponent content, @NotNull String name2, boolean selectTab) {
        Pair tab;
        if (content == null) {
            TabbedContentImpl.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            TabbedContentImpl.$$$reportNull$$$0(1);
        }
        if (!this.myTabs.contains(tab = Pair.create((Object)name2, (Object)content))) {
            this.myTabs.add((Pair<String, JComponent>)tab);
        }
        if (selectTab && this.getComponent() != content) {
            this.setComponent(content);
        }
    }

    @Override
    public void setComponent(JComponent component) {
        Container parent;
        JComponent currentComponent = this.getComponent();
        Container container = parent = currentComponent == null ? null : currentComponent.getParent();
        if (parent != null) {
            parent.remove(currentComponent);
            parent.add(component);
        }
        super.setComponent(component);
    }

    public void removeContent(@NotNull JComponent content) {
        int index;
        if (content == null) {
            TabbedContentImpl.$$$reportNull$$$0(2);
        }
        Pair<String, JComponent> toRemove2 = null;
        for (Pair<String, JComponent> tab : this.myTabs) {
            if (tab.second != content) continue;
            toRemove2 = tab;
            break;
        }
        if ((index = this.myTabs.indexOf(toRemove2)) != -1) {
            this.myTabs.remove(index);
            int n = index = index > 0 ? index - 1 : index;
            if (index < this.myTabs.size()) {
                this.selectContent(index);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.getTabName();
    }

    public void selectContent(int index) {
        Pair<String, JComponent> tab = this.myTabs.get(index);
        this.setDisplayName((String)tab.first);
        this.setComponent((JComponent)tab.second);
    }

    public int getSelectedIndex() {
        JComponent selected = this.getComponent();
        for (int i = 0; i < this.myTabs.size(); ++i) {
            if (this.myTabs.get((int)i).second != selected) continue;
            return i;
        }
        return -1;
    }

    public boolean findAndSelectContent(@NotNull JComponent contentComponent) {
        String tabName;
        if (contentComponent == null) {
            TabbedContentImpl.$$$reportNull$$$0(3);
        }
        if ((tabName = this.findTabNameByComponent(contentComponent)) != null) {
            this.setDisplayName(tabName);
            this.setComponent(contentComponent);
            return true;
        }
        return false;
    }

    @Override
    public String getTabName() {
        String selected = this.findTabNameByComponent(this.getComponent());
        if (this.myPrefix != null) {
            selected = this.myPrefix + ": " + selected;
        }
        return selected;
    }

    private String findTabNameByComponent(JComponent c) {
        for (Pair<String, JComponent> tab : this.myTabs) {
            if (tab.second != c) continue;
            return (String)tab.first;
        }
        return null;
    }

    public List<Pair<String, JComponent>> getTabs() {
        return Collections.unmodifiableList(this.myTabs);
    }

    public String getTitlePrefix() {
        return this.myPrefix;
    }

    public void setTitlePrefix(String titlePrefix) {
        this.myPrefix = titlePrefix;
    }

    public void split() {
        ArrayList<Pair<String, JComponent>> copy = new ArrayList<Pair<String, JComponent>>(this.myTabs);
        int selectedTab = ContentUtilEx.getSelectedTab(this);
        ContentManager manager = this.getManager();
        String prefix = this.getTitlePrefix();
        manager.removeContent((Content)this, false);
        PropertiesComponent.getInstance().setValue("tabbed.toolwindow.expanded." + prefix, Boolean.TRUE.toString());
        for (int i = 0; i < copy.size(); ++i) {
            boolean select = i == selectedTab;
            JComponent component = (JComponent)((Pair)copy.get((int)i)).second;
            String tabName = (String)((Pair)copy.get((int)i)).first;
            ContentUtilEx.addTabbedContent(manager, component, prefix, tabName, select);
        }
        Disposer.dispose((Disposable)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTabs.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/content/impl/TabbedContentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndSelectContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

