/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.popup.WizardPopup;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class MnemonicsSearch<T> {
    private final WizardPopup myPopup;
    private final Map<String, T> myChar2ValueMap = new HashMap<String, T>();

    public MnemonicsSearch(WizardPopup popup2) {
        this.myPopup = popup2;
        if (!this.myPopup.getStep().isMnemonicsNavigationEnabled()) {
            return;
        }
        MnemonicNavigationFilter filter2 = this.myPopup.getStep().getMnemonicNavigationFilter();
        List values = filter2.getValues();
        for (Object each : values) {
            int pos = filter2.getMnemonicPos(each);
            if (pos == -1) continue;
            String text2 = filter2.getTextFor(each);
            String charText = text2.substring(pos + 1, pos + 2);
            this.myChar2ValueMap.put(StringUtil.toUpperCase((String)charText), each);
            this.myChar2ValueMap.put(charText.toLowerCase(), each);
        }
    }

    public void processKeyEvent(@NotNull KeyEvent e) {
        String s;
        T toSelect2;
        if (e == null) {
            MnemonicsSearch.$$$reportNull$$$0(0);
        }
        if (e.isConsumed()) {
            return;
        }
        if (e.getID() != 400) {
            return;
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myPopup.getSpeedSearch().getFilter())) {
            return;
        }
        if (Character.isLetterOrDigit(e.getKeyChar()) && (toSelect2 = this.myChar2ValueMap.get(s = Character.toString(e.getKeyChar()))) != null) {
            this.select(toSelect2);
            e.consume();
        }
    }

    protected abstract void select(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/popup/util/MnemonicsSearch", "processKeyEvent"));
    }
}

