/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;

public class MessageBusUtil {
    private static <T> Runnable createPublisherRunnable(Project project2, Topic<T> topic, Consumer<T> listener2) {
        return () -> {
            if (project2.isDisposed()) {
                throw new ProcessCanceledException();
            }
            listener2.consume(project2.getMessageBus().syncPublisher(topic));
        };
    }

    public static <T> void invokeLaterIfNeededOnSyncPublisher(Project project2, Topic<T> topic, Consumer<T> listener2) {
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = MessageBusUtil.createPublisherRunnable(project2, topic, listener2);
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2);
        }
    }
}

