/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.PsiFileGistImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.gist.VirtualFileGistImpl;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GistManagerImpl
extends GistManager {
    private static final Set<String> ourKnownIds = ContainerUtil.newConcurrentSet();
    private static final String ourPropertyName = "file.gist.reindex.count";
    private final AtomicInteger myReindexCount = new AtomicInteger(PropertiesComponent.getInstance().getInt("file.gist.reindex.count", 0));

    public GistManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (events.stream().anyMatch(this::shouldDropCache)) {
                    GistManagerImpl.this.invalidateData();
                }
            }

            private boolean shouldDropCache(VFileEvent e) {
                if (!(e instanceof VFilePropertyChangeEvent)) {
                    return false;
                }
                String propertyName = ((VFilePropertyChangeEvent)e).getPropertyName();
                return propertyName.equals("name") || propertyName.equals("encoding");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/gist/GistManagerImpl$1", "after"));
            }
        });
    }

    @NotNull
    public <Data> VirtualFileGist<Data> newVirtualFileGist(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData2) {
        if (id == null) {
            GistManagerImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            GistManagerImpl.$$$reportNull$$$0(1);
        }
        if (calcData2 == null) {
            GistManagerImpl.$$$reportNull$$$0(2);
        }
        if (!ourKnownIds.add(id)) {
            throw new IllegalArgumentException("Gist '" + id + "' is already registered");
        }
        VirtualFileGistImpl<Data> virtualFileGistImpl = new VirtualFileGistImpl<Data>(id, version, externalizer, calcData2);
        if (virtualFileGistImpl == null) {
            GistManagerImpl.$$$reportNull$$$0(3);
        }
        return virtualFileGistImpl;
    }

    @NotNull
    public <Data> PsiFileGist<Data> newPsiFileGist(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<PsiFile, Data> calculator) {
        if (id == null) {
            GistManagerImpl.$$$reportNull$$$0(4);
        }
        if (externalizer == null) {
            GistManagerImpl.$$$reportNull$$$0(5);
        }
        if (calculator == null) {
            GistManagerImpl.$$$reportNull$$$0(6);
        }
        PsiFileGistImpl<Data> psiFileGistImpl = new PsiFileGistImpl<Data>(id, version, externalizer, calculator);
        if (psiFileGistImpl == null) {
            GistManagerImpl.$$$reportNull$$$0(7);
        }
        return psiFileGistImpl;
    }

    int getReindexCount() {
        return this.myReindexCount.get();
    }

    public void invalidateData() {
        PropertiesComponent.getInstance().setValue(ourPropertyName, this.myReindexCount.incrementAndGet(), 0);
    }

    public void resetReindexCount() {
        this.myReindexCount.set(0);
        PropertiesComponent.getInstance().unsetValue(ourPropertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calcData";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/gist/GistManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/gist/GistManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newVirtualFileGist";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newPsiFileGist";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newVirtualFileGist";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newPsiFileGist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

