/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UpdatableIndex;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexConfiguration {
    private final Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> myIndices = new THashMap();
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();
    private final List<ID<?, ?>> myIndicesWithoutFileTypeInfo = new ArrayList();
    private final Map<FileType, List<ID<?, ?>>> myFileType2IndicesWithFileTypeInfoMap = new THashMap();
    private volatile boolean myFreezed;

    IndexConfiguration() {
    }

    <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        assert (this.myFreezed);
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair2 = this.myIndices.get(indexId);
        return pair2 != null ? (UpdatableIndex)pair2.getFirst() : null;
    }

    FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(0);
        }
        assert (this.myFreezed);
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair2 = this.myIndices.get(indexId);
        assert (pair2 != null) : "Index data is absent for index " + indexId;
        return (FileBasedIndex.InputFilter)pair2.getSecond();
    }

    void freeze() {
        this.myFreezed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> void registerIndex(ID<K, V> name2, @NotNull UpdatableIndex<K, V, FileContent> index, FileBasedIndex.InputFilter inputFilter, int version, @Nullable Collection<FileType> associatedFileTypes) {
        if (index == null) {
            IndexConfiguration.$$$reportNull$$$0(1);
        }
        assert (!this.myFreezed);
        Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> map = this.myIndices;
        synchronized (map) {
            this.myIndexIdToVersionMap.put(name2, version);
            if (associatedFileTypes != null && !associatedFileTypes.isEmpty()) {
                for (FileType fileType : associatedFileTypes) {
                    List<ID<?, ?>> ids = this.myFileType2IndicesWithFileTypeInfoMap.get(fileType);
                    if (ids == null) {
                        ids = new ArrayList(5);
                        this.myFileType2IndicesWithFileTypeInfoMap.put(fileType, ids);
                    }
                    ids.add(name2);
                }
            } else {
                this.myIndicesWithoutFileTypeInfo.add(name2);
            }
            Pair old = this.myIndices.put(name2, new Pair(index, (Object)inputFilter));
            if (old != null) {
                throw new IllegalStateException("Index " + old.first + " already registered for the name '" + name2 + "'");
            }
        }
    }

    List<ID<?, ?>> getFileTypesForIndex(FileType fileType) {
        assert (this.myFreezed);
        List<ID<?, ?>> ids = this.myFileType2IndicesWithFileTypeInfoMap.get(fileType);
        if (ids == null) {
            ids = this.myIndicesWithoutFileTypeInfo;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeFileTypeMappingForIndices() {
        assert (!this.myFreezed);
        Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> map = this.myIndices;
        synchronized (map) {
            for (List<ID<?, ?>> value2 : this.myFileType2IndicesWithFileTypeInfoMap.values()) {
                value2.addAll(this.myIndicesWithoutFileTypeInfo);
            }
        }
    }

    Collection<ID<?, ?>> getIndexIDs() {
        assert (this.myFreezed);
        return this.myIndices.keySet();
    }

    boolean hasIndex(ID<?, ?> name2) {
        assert (this.myFreezed);
        return this.myIndices.containsKey(name2);
    }

    int getIndexVersion(ID<?, ?> id) {
        assert (this.myFreezed);
        return this.myIndexIdToVersionMap.get(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/IndexConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInputFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

