/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.ConnectToChannelResult;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.BootstrapUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.BuiltInServer;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u00a4\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a6\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u0014H\u0002\u001a.\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002\u001a \u0010#\u001a\u00020$2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020$\u001a\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0002H\u0002\u001a\u0006\u0010)\u001a\u00020\u001a\u001a&\u0010*\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020$H\u0007\u001a\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/\u001a\u0012\u00100\u001a\u0004\u0018\u00010\u00012\u0006\u00101\u001a\u00020\u0014H\u0002\u001a2\u00102\u001a\u000203*\u0002042#\b\u0004\u00105\u001a\u001d\u0012\u0013\u0012\u001104\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(9\u0012\u0004\u0012\u00020306H\u0086\b\u001a\n\u0010:\u001a\u000203*\u00020\f\u001a0\u0010;\u001a\u00020\u0018*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00142\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fH\u0007\u001a#\u0010<\u001a\u00020\u001a*\u00020\u001a2\u0014\b\u0004\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020306H\u0086\b\u001a \u0010>\u001a\u00020$*\u00020\u00052\b\b\u0002\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020$H\u0007\u001a\n\u0010?\u001a\u00020$*\u00020\u0005\u001a\n\u0010@\u001a\u00020$*\u00020\u0005\u001a\n\u0010A\u001a\u00020\u0001*\u00020B\u001a&\u0010C\u001a\u0002HD\"\u0004\b\u0000\u0010D*\u00020B2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002HD0EH\u0086\b\u00a2\u0006\u0002\u0010F\u001a\u0014\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020I0H*\u00020/H\u0002\u001a\n\u0010J\u001a\u000203*\u00020K\u001a\u0012\u0010L\u001a\u00020\u0014*\u00020B2\u0006\u0010M\u001a\u00020N\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006O"}, d2={"host", "", "Lcom/intellij/util/Url;", "getHost", "(Lcom/intellij/util/Url;)Ljava/lang/String;", "Lio/netty/handler/codec/http/HttpRequest;", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "origin", "getOrigin", "referrer", "getReferrer", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "userAgent", "getUserAgent", "MultiThreadEventLoopGroup", "Lio/netty/channel/MultithreadEventLoopGroup;", "workerCount", "", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "connectNio", "Lcom/intellij/util/io/ConnectToChannelResult;", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "remoteAddress", "Ljava/net/InetSocketAddress;", "maxAttemptCount", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "_attemptCount", "doConnect", "isLocalHost", "", "onlyAnyOrLoopback", "hostsOnly", "isTrustedChromeExtension", "url", "oioClientBootstrap", "parseAndCheckIsLocalHost", "uri", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "sleep", "time", "addChannelListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "future", "closeAndShutdownEventLoop", "connectRetrying", "handler", "task", "isLocalOrigin", "isRegularBrowser", "isWriteFromBrowserWithoutOrigin", "readUtf8", "Lio/netty/buffer/ByteBuf;", "releaseIfError", "T", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "serverSocketChannelClass", "Ljava/lang/Class;", "Lio/netty/channel/socket/ServerSocketChannel;", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "writeUtf8", "data", "", "platform-impl"})
public final class NettyKt {
    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    @NotNull
    public static final Bootstrap handler(@NotNull Bootstrap $receiver, @NotNull Function1<? super Channel, Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(NettyKt.serverSocketChannelClass(group));
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    private static final Class<? extends ServerSocketChannel> serverSocketChannelClass(@NotNull EventLoopGroup $receiver) {
        Class<NioServerSocketChannel> clazz;
        if ($receiver instanceof NioEventLoopGroup) {
            clazz = NioServerSocketChannel.class;
        } else if ($receiver instanceof OioEventLoopGroup) {
            clazz = OioServerSocketChannel.class;
        } else if (SystemInfo.isMacOSSierra && $receiver instanceof KQueueEventLoopGroup) {
            clazz = KQueueServerSocketChannel.class;
        } else {
            throw (Throwable)new Exception("Unknown event loop group type: " + $receiver.getClass().getName());
        }
        return clazz;
    }

    public static final void addChannelListener(@NotNull ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, Unit> listener2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener2){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(@NotNull EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            ((OioEventLoopGroup)$receiver).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(@NotNull Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition2 = stopCondition;
            if (condition2 == null) {
                Condition condition3 = Conditions.alwaysFalse();
                condition2 = condition3;
                Intrinsics.checkExpressionValueIsNotNull((Object)condition3, (String)"Conditions.alwaysFalse<Void>()");
            }
            return NettyKt.doConnect($receiver, remoteAddress, maxAttemptCount, condition2);
        }
        catch (Throwable e) {
            return new ConnectToChannelResult(e);
        }
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ConnectToChannelResult connectRetrying$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, int n, Condition condition2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        if ((n2 & 4) != 0) {
            condition2 = null;
        }
        return NettyKt.connectRetrying(bootstrap, inetSocketAddress, n, (Condition<Void>)condition2);
    }

    @JvmOverloads
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, int maxAttemptCount) {
        return NettyKt.connectRetrying$default($receiver, remoteAddress, maxAttemptCount, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress) {
        return NettyKt.connectRetrying$default($receiver, remoteAddress, 0, null, 6, null);
    }

    private static final ConnectToChannelResult doConnect(Bootstrap bootstrap, InetSocketAddress remoteAddress, int maxAttemptCount, Condition<Void> stopCondition) {
        int attemptCount = 0;
        if (!(bootstrap.config().group() instanceof OioEventLoopGroup)) {
            return NettyKt.connectNio(bootstrap, remoteAddress, maxAttemptCount, stopCondition, attemptCount);
        }
        bootstrap.validate();
        while (true) {
            try {
                OioSocketChannel channel = new OioSocketChannel(new Socket(remoteAddress.getAddress(), remoteAddress.getPort()));
                BootstrapUtil.initAndRegister((Channel)channel, bootstrap).sync();
                return new ConnectToChannelResult((Channel)channel);
            }
            catch (IOException e) {
                if (stopCondition.value(null)) {
                    return new ConnectToChannelResult(null, 1, null);
                }
                if (maxAttemptCount == -1) {
                    String string = NettyKt.sleep(300);
                    if (string != null) {
                        String string2;
                        String it = string2 = string;
                        return new ConnectToChannelResult(it);
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount < maxAttemptCount) {
                    String string;
                    String string3 = NettyKt.sleep(attemptCount * 100);
                    if (string3 == null) continue;
                    String it = string = string3;
                    return new ConnectToChannelResult(it);
                    continue;
                }
                return new ConnectToChannelResult(e);
            }
            break;
        }
    }

    private static final ConnectToChannelResult connectNio(Bootstrap bootstrap, InetSocketAddress remoteAddress, int maxAttemptCount, Condition<Void> stopCondition, int _attemptCount) {
        ChannelFuture future2;
        int attemptCount = _attemptCount;
        while (true) {
            String string;
            if ((future2 = bootstrap.connect((SocketAddress)remoteAddress).awaitUninterruptibly()).isSuccess()) {
                if (!future2.channel().isOpen()) continue;
                return new ConnectToChannelResult(future2.channel());
            }
            if (stopCondition.value(null)) {
                return new ConnectToChannelResult(null, 1, null);
            }
            if (maxAttemptCount == -1) {
                String string2 = NettyKt.sleep(300);
                if (string2 != null) {
                    String string3;
                    String it = string3 = string2;
                    return new ConnectToChannelResult(it);
                }
                ++attemptCount;
                continue;
            }
            if (++attemptCount >= maxAttemptCount) break;
            String string4 = NettyKt.sleep(attemptCount * 100);
            if (string4 == null) continue;
            String it = string = string4;
            return new ConnectToChannelResult(it);
        }
        Throwable cause = future2.cause();
        if (cause == null) {
            return new ConnectToChannelResult("Cannot connect: unknown error");
        }
        return new ConnectToChannelResult(cause);
    }

    private static final String sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ignored) {
            return "Interrupted";
        }
        return null;
    }

    @NotNull
    public static final String getUriScheme(@NotNull Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @Nullable
    public static final String getHost(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
    }

    @Nullable
    public static final String getOrigin(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.ORIGIN);
    }

    @Nullable
    public static final String getReferrer(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.REFERER);
    }

    @Nullable
    public static final String getUserAgent(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.USER_AGENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T releaseIfError(@NotNull ByteBuf $receiver, @NotNull Function0<? extends T> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            return (T)task.invoke();
        }
        catch (Exception e) {
            try {
                $receiver.release();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                throw (Throwable)e;
            }
        }
    }

    public static final boolean isLocalHost(@NotNull String host, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        if (onlyAnyOrLoopback && !InetAddresses.isInetAddress((String)host)) {
            return false;
        }
        isLocalHost.1 isLocal$ = isLocalHost.1.INSTANCE;
        try {
            InetAddress address = InetAddress.getByName(host);
            if (!isLocal$.invoke(address)) {
                return false;
            }
            if (hostsOnly && !InetAddresses.isInetAddress((String)host)) {
                InetAddress inetAddress = HostsFileEntriesResolver.DEFAULT.address(host, ResolvedAddressTypes.IPV4_PREFERRED);
                InetAddress it = inetAddress;
                return it != null && isLocalHost.1.INSTANCE.invoke(it);
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static /* bridge */ /* synthetic */ boolean isLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalHost(string, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $receiver, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return NettyKt.parseAndCheckIsLocalHost(NettyKt.getOrigin($receiver), onlyAnyOrLoopback, hostsOnly) && NettyKt.parseAndCheckIsLocalHost(NettyKt.getReferrer($receiver), onlyAnyOrLoopback, hostsOnly);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean isLocalOrigin$default(HttpRequest httpRequest, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalOrigin(httpRequest, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $receiver, boolean onlyAnyOrLoopback) {
        return NettyKt.isLocalOrigin$default($receiver, onlyAnyOrLoopback, false, 2, null);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $receiver) {
        return NettyKt.isLocalOrigin$default($receiver, false, false, 3, null);
    }

    private static final boolean isTrustedChromeExtension(Url url) {
        return Intrinsics.areEqual((Object)url.getScheme(), (Object)"chrome-extension") && (Intrinsics.areEqual((Object)url.getAuthority(), (Object)"hmhgeddbohgjknpmjagkdomcpobmllji") || Intrinsics.areEqual((Object)url.getAuthority(), (Object)"offnedcbhjldheanlbojaefbfbllddna"));
    }

    private static final String getHost(@NotNull Url $receiver) {
        String string;
        String string2 = $receiver.getAuthority();
        if (string2 != null) {
            String string3 = string2;
            String it = string3;
            int portIndex = StringsKt.indexOf$default((CharSequence)it, (char)':', (int)0, (boolean)false, (int)6, null);
            if (portIndex > 0) {
                String string4 = it;
                int n = 0;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n, portIndex);
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = it;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (uri == null) return true;
        if (Intrinsics.areEqual((Object)uri, (Object)"about:blank")) {
            return true;
        }
        try {
            Url url = Urls.parse(uri, false);
            if (url == null) return false;
            Url parsedUri = url;
            String host = NettyKt.getHost(parsedUri);
            if (host == null) return false;
            Url url2 = parsedUri;
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"parsedUri");
            if (NettyKt.isTrustedChromeExtension(url2)) return true;
            if (!NettyKt.isLocalHost(host, onlyAnyOrLoopback, hostsOnly)) return false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean parseAndCheckIsLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.parseAndCheckIsLocalHost(string, bl, bl2);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri, boolean onlyAnyOrLoopback) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, onlyAnyOrLoopback, false, 4, null);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, false, false, 6, null);
    }

    public static final boolean isRegularBrowser(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = NettyKt.getUserAgent($receiver);
        return string != null ? StringsKt.startsWith$default((String)string, (String)"Mozilla/5.0", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isWriteFromBrowserWithoutOrigin(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HttpMethod method = $receiver.method();
        CharSequence charSequence = NettyKt.getOrigin($receiver);
        return (charSequence == null || charSequence.length() == 0) && NettyKt.isRegularBrowser($receiver) && (Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PATCH) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PUT) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.DELETE));
    }

    @NotNull
    public static final String readUtf8(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.toString(Charsets.UTF_8);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toString(Charsets.UTF_8)");
        return string;
    }

    public static final int writeUtf8(@NotNull ByteBuf $receiver, @NotNull CharSequence data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return $receiver.writeCharSequence(data, Charsets.UTF_8);
    }

    @NotNull
    public static final MultithreadEventLoopGroup MultiThreadEventLoopGroup(int workerCount, @NotNull ThreadFactory threadFactory) {
        Intrinsics.checkParameterIsNotNull((Object)threadFactory, (String)"threadFactory");
        if (SystemInfo.isMacOSSierra && SystemProperties.getBooleanProperty((String)"native.net.io", (boolean)false)) {
            try {
                return (MultithreadEventLoopGroup)new KQueueEventLoopGroup(workerCount, threadFactory);
            }
            catch (Throwable e) {
                Logger logger = Logger.getInstance(BuiltInServer.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Cannot use native event loop group", e);
            }
        }
        return (MultithreadEventLoopGroup)new NioEventLoopGroup(workerCount, threadFactory);
    }

    @NotNull
    public static final MultithreadEventLoopGroup MultiThreadEventLoopGroup(int workerCount) {
        if (SystemInfo.isMacOSSierra && SystemProperties.getBooleanProperty((String)"native.net.io", (boolean)false)) {
            try {
                return (MultithreadEventLoopGroup)new KQueueEventLoopGroup(workerCount, (Executor)PooledThreadExecutor.INSTANCE);
            }
            catch (Throwable e) {
                Logger logger = Logger.getInstance(BuiltInServer.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error("Cannot use native event loop group", e);
            }
        }
        return (MultithreadEventLoopGroup)new NioEventLoopGroup(workerCount, (Executor)PooledThreadExecutor.INSTANCE);
    }
}

