/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"assertDirectoryContentMatches", "", "file", "Ljava/io/File;", "spec", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "relativePath", "", "assertDirectoryMatches", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "convertToText", "", "testFramework"})
public final class DirectoryContentSpecImplKt {
    public static final void assertDirectoryContentMatches(@NotNull File file2, @NotNull DirectoryContentSpecImpl spec, @NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        DirectoryContentSpecImpl directoryContentSpecImpl = spec;
        if (directoryContentSpecImpl instanceof DirectorySpec) {
            DirectoryContentSpecImplKt.assertDirectoryMatches(file2, (DirectorySpecBase)spec, relativePath);
        } else if (directoryContentSpecImpl instanceof ZipSpec) {
            File dirForExtracted = FileUtil.createTempDirectory((String)("extracted-" + file2.getName()), null, (boolean)false);
            ZipUtil.extract((File)file2, (File)dirForExtracted, null);
            File file3 = dirForExtracted;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"dirForExtracted");
            DirectoryContentSpecImplKt.assertDirectoryMatches(file3, (DirectorySpecBase)spec, relativePath);
            FileUtil.delete((File)dirForExtracted);
        } else if (directoryContentSpecImpl instanceof FileSpec) {
            byte[] actualBytes;
            Assert.assertTrue((String)("" + file2 + " is not a file"), (boolean)file2.isFile());
            if (((FileSpec)spec).getContent() != null && !Arrays.equals(actualBytes = FileUtil.loadFileBytes((File)file2), ((FileSpec)spec).getContent())) {
                String place;
                String actualString = DirectoryContentSpecImplKt.convertToText(actualBytes);
                String expectedString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                String string = place = Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "";
                if (actualString != null && expectedString != null) {
                    Assert.assertEquals((String)("File content mismatch" + place + ':'), (Object)expectedString, (Object)actualString);
                } else {
                    Assert.fail((String)("Binary file content mismatch" + place));
                }
            }
        }
    }

    private static final String convertToText(@NotNull byte[] $receiver) {
        Charset charset;
        CharsetToolkit.GuessedEncoding encoding = new CharsetToolkit($receiver, Charsets.UTF_8).guessFromContent($receiver.length);
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        return new String($receiver, charset2);
    }

    private static final void assertDirectoryMatches(File file2, DirectorySpecBase spec, String relativePath) {
        Assert.assertTrue((String)("" + file2 + " is not a directory"), (boolean)file2.isDirectory());
        List actualChildrenNames = ArraysKt.sortedWith((Object[])file2.list(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Map<String, DirectoryContentSpecImpl> children2 = spec.getChildren();
        List expectedChildrenNames = CollectionsKt.sortedWith((Iterable)children2.keySet(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Assert.assertEquals((String)("Directory content mismatch" + (Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "") + ':'), (Object)CollectionsKt.joinToString$default((Iterable)expectedChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)actualChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Iterable $receiver$iv = actualChildrenNames;
        for (Object element$iv : $receiver$iv) {
            String child = (String)element$iv;
            File file3 = new File(file2, child);
            DirectoryContentSpecImpl directoryContentSpecImpl = children2.get(child);
            if (directoryContentSpecImpl == null) {
                Intrinsics.throwNpe();
            }
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(file3, directoryContentSpecImpl, "" + relativePath + '/' + child);
        }
    }
}

