/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomCustomAnnotationChecker;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtendsClassChecker
extends DomCustomAnnotationChecker<ExtendClass> {
    private static final GenericValueReferenceProvider ourProvider = new GenericValueReferenceProvider();

    @NotNull
    public Class<ExtendClass> getAnnotationClass() {
        if (ExtendClass.class == null) {
            ExtendsClassChecker.$$$reportNull$$$0(0);
        }
        return ExtendClass.class;
    }

    public List<DomElementProblemDescriptor> checkForProblems(@NotNull ExtendClass extend, @NotNull DomElement _element2, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (extend == null) {
            ExtendsClassChecker.$$$reportNull$$$0(1);
        }
        if (_element2 == null) {
            ExtendsClassChecker.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            ExtendsClassChecker.$$$reportNull$$$0(3);
        }
        if (helper == null) {
            ExtendsClassChecker.$$$reportNull$$$0(4);
        }
        if (!(_element2 instanceof GenericDomValue)) {
            return Collections.emptyList();
        }
        GenericDomValue element = (GenericDomValue)_element2;
        if (!ExtendsClassChecker.isPsiClassType(element)) {
            return Collections.emptyList();
        }
        Object valueObject = element.getValue();
        PsiClass psiClass = null;
        if (valueObject instanceof PsiClass) {
            psiClass = (PsiClass)valueObject;
        } else if (valueObject instanceof PsiClassType) {
            psiClass = ((PsiClassType)valueObject).resolve();
        }
        if (psiClass != null) {
            return ExtendsClassChecker.checkExtendClass(element, psiClass, extend.value(), extend.instantiatable(), extend.canBeDecorator(), extend.allowInterface(), extend.allowNonPublic(), extend.allowAbstract(), extend.allowEnum(), holder);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<DomElementProblemDescriptor> checkExtendClass(GenericDomValue element, PsiClass value2, String name2, boolean instantiatable, boolean canBeDecorator, boolean allowInterface, boolean allowNonPublic, boolean allowAbstract, boolean allowEnum, DomElementAnnotationHolder holder) {
        Project project2 = element.getManager().getProject();
        PsiClass extendClass = JavaPsiFacade.getInstance((Project)project2).findClass(name2, GlobalSearchScope.allScope((Project)project2));
        SmartList list2 = new SmartList();
        if (extendClass != null && !name2.equals(value2.getQualifiedName()) && !value2.isInheritor(extendClass, true)) {
            String message2 = DomBundle.message((String)"class.is.not.a.subclass", (Object[])new Object[]{value2.getQualifiedName(), extendClass.getQualifiedName()});
            list2.add((Object)holder.createProblem((DomElement)element, message2, new LocalQuickFix[0]));
        }
        if (instantiatable) {
            if (value2.hasModifierProperty("abstract")) {
                list2.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.is.not.concrete", (Object[])new Object[]{value2.getQualifiedName()}), new LocalQuickFix[0]));
            } else if (!allowNonPublic && !value2.hasModifierProperty("public")) {
                list2.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.is.not.public", (Object[])new Object[]{value2.getQualifiedName()}), new LocalQuickFix[0]));
            } else if (!PsiUtil.hasDefaultConstructor((PsiClass)value2, (boolean)true)) {
                if (canBeDecorator) {
                    boolean hasConstructor = false;
                    for (PsiMethod method : value2.getConstructors()) {
                        PsiClass psiClass;
                        PsiType psiType;
                        PsiTypeElement typeElement;
                        PsiParameterList psiParameterList = method.getParameterList();
                        if (psiParameterList.getParametersCount() != 1 || (typeElement = psiParameterList.getParameters()[0].getTypeElement()) == null || !((psiType = typeElement.getType()) instanceof PsiClassType) || (psiClass = ((PsiClassType)psiType).resolve()) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)extendClass, (boolean)true)) continue;
                        hasConstructor = true;
                        break;
                    }
                    if (!hasConstructor) {
                        list2.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.decorator.or.has.default.constructor", (Object[])new Object[]{value2.getQualifiedName()}), new LocalQuickFix[0]));
                    }
                } else {
                    list2.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"class.has.no.default.constructor", (Object[])new Object[]{value2.getQualifiedName()}), new LocalQuickFix[0]));
                }
            }
        }
        if (!allowInterface && value2.isInterface()) {
            list2.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"interface.not.allowed", (Object[])new Object[]{value2.getQualifiedName()}), new LocalQuickFix[0]));
        }
        if (!allowEnum && value2.isEnum()) {
            list2.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"enum.not.allowed", (Object[])new Object[]{value2.getQualifiedName()}), new LocalQuickFix[0]));
        }
        if (!allowAbstract && value2.hasModifierProperty("abstract") && !value2.isInterface()) {
            list2.add((Object)holder.createProblem((DomElement)element, DomBundle.message((String)"abstract.class.not.allowed", (Object[])new Object[]{value2.getQualifiedName()}), new LocalQuickFix[0]));
        }
        SmartList smartList = list2;
        if (smartList == null) {
            ExtendsClassChecker.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    public static List<DomElementProblemDescriptor> checkExtendsClassInReferences(GenericDomValue element, DomElementAnnotationHolder holder) {
        PsiReference[] references;
        if (!ExtendsClassChecker.isPsiClassType(element)) {
            return Collections.emptyList();
        }
        Object valueObject = element.getValue();
        if (!(valueObject instanceof PsiClass)) {
            return Collections.emptyList();
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)element);
        if (valueElement == null) {
            return Collections.emptyList();
        }
        for (PsiReference reference : references = ourProvider.getReferencesByElement((PsiElement)valueElement, new ProcessingContext())) {
            String[] value2;
            if (!(reference instanceof JavaClassReference)) continue;
            PsiReferenceProvider psiReferenceProvider = ((JavaClassReference)reference).getProvider();
            String[] stringArray = value2 = psiReferenceProvider instanceof JavaClassReferenceProvider ? JavaClassReferenceProvider.EXTEND_CLASS_NAMES.getValue(((JavaClassReferenceProvider)psiReferenceProvider).getOptions()) : null;
            if (value2 == null || value2.length == 0) continue;
            for (String className : value2) {
                List<DomElementProblemDescriptor> problemDescriptors = ExtendsClassChecker.checkExtendClass(element, (PsiClass)valueObject, className, false, false, true, false, true, true, holder);
                if (problemDescriptors.isEmpty()) continue;
                return problemDescriptors;
            }
        }
        return Collections.emptyList();
    }

    private static boolean isPsiClassType(GenericDomValue element) {
        Class genericValueParameter = DomUtil.getGenericValueParameter((Type)element.getDomElementType());
        return genericValueParameter != null && (ReflectionUtil.isAssignable((Class)genericValueParameter, PsiClass.class) || ReflectionUtil.isAssignable((Class)genericValueParameter, PsiType.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/ExtendsClassChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extend";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/ExtendsClassChecker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkExtendClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkForProblems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

