/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GetInvocation
implements Invocation {
    private static final Key<CachedValue<List<Pair<Converter, Object>>>> DOM_VALUE_KEY = Key.create((String)"Dom element value key");
    private final Converter myConverter;

    protected GetInvocation(Converter converter2) {
        assert (converter2 != null);
        this.myConverter = converter2;
    }

    @Override
    public Object invoke(DomInvocationHandler<?, ?> handler2, Object[] args) throws Throwable {
        if (this.myConverter == Converter.EMPTY_CONVERTER) {
            return GetInvocation.getValueInner(handler2, this.myConverter);
        }
        CachedValue value2 = (CachedValue)handler2.getUserData(DOM_VALUE_KEY);
        if (value2 == null) {
            DomManagerImpl domManager = handler2.getManager();
            Project project2 = domManager.getProject();
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
            value2 = cachedValuesManager.createCachedValue(() -> {
                List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
                return CachedValueProvider.Result.create((Object)list2, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, domManager, ProjectRootManager.getInstance((Project)project2)});
            }, false);
            handler2.putUserData(DOM_VALUE_KEY, value2);
        }
        return this.getOrCalcValue(handler2, (List)value2.getValue());
    }

    @Nullable
    private Object getOrCalcValue(DomInvocationHandler<?, ?> handler2, List<Pair<Converter, Object>> list2) {
        if (!list2.isEmpty()) {
            for (int i = 0; i < list2.size(); ++i) {
                Pair<Converter, Object> pair2 = list2.get(i);
                if (pair2.first != this.myConverter) continue;
                return pair2.second;
            }
        }
        Object returnValue = GetInvocation.getValueInner(handler2, this.myConverter);
        list2.add((Pair<Converter, Object>)Pair.create((Object)this.myConverter, (Object)returnValue));
        return returnValue;
    }

    @Nullable
    private static Object getValueInner(DomInvocationHandler<?, ?> handler2, Converter converter2) {
        SubTag annotation = handler2.getAnnotation(SubTag.class);
        if (annotation != null && annotation.indicator()) {
            boolean tagNotNull;
            boolean bl = tagNotNull = handler2.getXmlTag() != null;
            if (converter2 == Converter.EMPTY_CONVERTER) {
                return tagNotNull ? "" : null;
            }
            return tagNotNull;
        }
        String tagValue = handler2.getValue();
        ConvertContext context = ConvertContextFactory.createConvertContext(handler2);
        for (DomReferenceInjector each : DomUtil.getFileElement(handler2).getFileDescription().getReferenceInjectors()) {
            tagValue = each.resolveString(tagValue, context);
        }
        return converter2.fromString(tagValue, context);
    }
}

