/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class ProgressManagerQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.AbstractTaskQueue");
    private final ProgressManager myProgressManager;
    private final Task.Backgroundable myQueuePollTask;
    private final Object myLock;
    private final Queue<Runnable> myQueue;
    private final Runnable myQueueWorker;
    @NotNull
    private final Project myProject;
    private volatile boolean myIsStarted;
    private boolean myActive;

    public ProgressManagerQueue(@NotNull Project project2, @NotNull String title) {
        if (project2 == null) {
            ProgressManagerQueue.$$$reportNull$$$0(0);
        }
        if (title == null) {
            ProgressManagerQueue.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myLock = new Object();
        this.myQueue = new ArrayDeque<Runnable>();
        this.myActive = false;
        this.myQueueWorker = new MyWorker();
        this.myProgressManager = ProgressManager.getInstance();
        this.myQueuePollTask = new Task.Backgroundable(project2, title){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManagerQueue.this.myQueueWorker.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/ProgressManagerQueue$1", "run"));
            }
        };
    }

    public void start() {
        this.myIsStarted = true;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.runMe();
        }
    }

    private void runMe() {
        if (!this.myIsStarted) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!this.myProject.isDisposed()) {
                this.myProgressManager.run((Task)this.myQueuePollTask);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    this.myProgressManager.run((Task)this.myQueuePollTask);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Runnable stuff) {
        if (stuff == null) {
            ProgressManagerQueue.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            stuff.run();
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            try {
                this.myQueue.add(stuff);
                if (!this.myActive) {
                    this.runMe();
                }
            }
            catch (Throwable t) {
                LOG.info(t);
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
            finally {
                this.myActive = true;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stuff";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/ProgressManagerQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyWorker
    implements Runnable {
        private MyWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object stuff;
                try {
                    Object object = ProgressManagerQueue.this.myLock;
                    synchronized (object) {
                        stuff = (Runnable)ProgressManagerQueue.this.myQueue.poll();
                    }
                    if (stuff == null) continue;
                    try {
                        stuff.run();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                    continue;
                }
                catch (Throwable t) {
                    LOG.info(t);
                    continue;
                }
                finally {
                    stuff = ProgressManagerQueue.this.myLock;
                    synchronized (stuff) {
                        if (ProgressManagerQueue.this.myQueue.isEmpty()) {
                            ProgressManagerQueue.this.myActive = false;
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }
}

