/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.CommitMessageInspectionDetails;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessageInspectionsPanel
extends BorderLayoutPanel
implements Disposable,
UnnamedConfigurable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommitMessageInspectionProfile myProfile;
    @NotNull
    private final List<ToolDescriptors> myInitialToolDescriptors;
    @NotNull
    private final Map<HighlightDisplayKey, CommitMessageInspectionDetails> myToolDetails;
    @NotNull
    private final InspectionConfigTreeNode myRoot;
    private InspectionProfileModifiableModel myModifiableModel;
    private InspectionsConfigTreeTable myInspectionsTable;
    private Wrapper myDetailsPanel;
    private CommitMessageInspectionDetails myCurrentDetails;

    public CommitMessageInspectionsPanel(@NotNull Project project2) {
        if (project2 == null) {
            CommitMessageInspectionsPanel.$$$reportNull$$$0(0);
        }
        this.myInitialToolDescriptors = ContainerUtil.newArrayList();
        this.myToolDetails = ContainerUtil.newHashMap();
        this.myRoot = new InspectionConfigTreeNode.Group("");
        this.myDetailsPanel = new Wrapper(){

            public boolean isNull() {
                return false;
            }
        };
        this.myProject = project2;
        this.myProfile = CommitMessageInspectionProfile.getInstance(this.myProject);
        this.resetProfileModel();
        this.init();
        this.setPreferredSize((Dimension)JBUI.size((int)650, (int)120));
    }

    private void resetProfileModel() {
        this.myModifiableModel = new InspectionProfileModifiableModel(this.myProfile);
    }

    private void initToolDescriptors() {
        this.myInitialToolDescriptors.clear();
        for (ScopeToolState state : this.myModifiableModel.getDefaultStates(this.myProject)) {
            this.myInitialToolDescriptors.add(ToolDescriptors.fromScopeToolState(state, this.myModifiableModel, this.myProject));
        }
    }

    private void buildInspectionsModel() {
        this.myRoot.removeAllChildren();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors) {
            this.myRoot.add(new MyInspectionTreeNode(toolDescriptors));
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)new InspectionsConfigTreeComparator());
    }

    private void init() {
        this.myInspectionsTable = InspectionsConfigTreeTable.create(new MyInspectionsTableSettings(this.myProject, this.myRoot), this);
        this.myInspectionsTable.setRootVisible(false);
        this.myInspectionsTable.setTreeCellRenderer((TreeCellRenderer)((Object)new MyInspectionsTreeRenderer()));
        this.myInspectionsTable.setSelectionMode(0);
        this.myInspectionsTable.getTree().getSelectionModel().setSelectionMode(1);
        this.myInspectionsTable.getTree().addTreeSelectionListener(e -> this.updateDetailsPanel());
        this.myInspectionsTable.setBorder(IdeBorderFactory.createBorder());
        JBSplitter splitter = new JBSplitter("CommitMessageInspectionsPanelSplitter", 0.5f);
        splitter.setShowDividerIcon(false);
        splitter.setFirstComponent((JComponent)((Object)this.myInspectionsTable));
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.addToCenter((Component)splitter);
    }

    private void updateDetailsPanel() {
        MyInspectionTreeNode node = this.getSelectedNode();
        if (node == null && this.myCurrentDetails != null || node != null && (this.myCurrentDetails == null || node.getKey() != this.myCurrentDetails.getKey())) {
            this.setDetails(node);
        }
        if (this.myCurrentDetails != null) {
            this.myCurrentDetails.update();
        }
    }

    private void setDetails(@Nullable MyInspectionTreeNode node) {
        this.myCurrentDetails = node != null ? this.myToolDetails.computeIfAbsent(node.getKey(), key2 -> this.createDetails(node)) : null;
        this.myDetailsPanel.setContent(this.myCurrentDetails != null ? this.myCurrentDetails.createComponent() : null);
        this.myDetailsPanel.repaint();
    }

    @NotNull
    private CommitMessageInspectionDetails createDetails(@NotNull MyInspectionTreeNode node) {
        if (node == null) {
            CommitMessageInspectionsPanel.$$$reportNull$$$0(1);
        }
        CommitMessageInspectionDetails details = new CommitMessageInspectionDetails(this.myProject, this.myModifiableModel, node.getDefaultDescriptor());
        details.addListener(severity -> this.myInspectionsTable.updateUI());
        CommitMessageInspectionDetails commitMessageInspectionDetails = details;
        if (commitMessageInspectionDetails == null) {
            CommitMessageInspectionsPanel.$$$reportNull$$$0(2);
        }
        return commitMessageInspectionDetails;
    }

    @Nullable
    private MyInspectionTreeNode getSelectedNode() {
        TreePath selectedPath = this.myInspectionsTable.getTree().getPathForRow(this.myInspectionsTable.getSelectedRow());
        return selectedPath != null ? (MyInspectionTreeNode)selectedPath.getLastPathComponent() : null;
    }

    public void dispose() {
    }

    @Nullable
    public JComponent createComponent() {
        return this;
    }

    public void reset() {
        this.myToolDetails.clear();
        this.myModifiableModel.getAllTools().forEach(ScopeToolState::resetConfigPanel);
        this.resetProfileModel();
        this.initToolDescriptors();
        TreeState state = TreeState.createOn((JTree)this.myInspectionsTable.getTree(), (DefaultMutableTreeNode)this.myRoot);
        this.buildInspectionsModel();
        ((DefaultTreeModel)this.myInspectionsTable.getTree().getModel()).reload();
        state.applyTo((JTree)this.myInspectionsTable.getTree(), (Object)this.myRoot);
    }

    public boolean isModified() {
        return ContainerUtil.exists(this.myInitialToolDescriptors, toolDescriptors -> SingleInspectionProfilePanel.areToolDescriptorsChanged(this.myProject, this.myModifiableModel, toolDescriptors)) || ContainerUtil.exists(this.myToolDetails.values(), CommitMessageInspectionDetails::isModified);
    }

    public void apply() throws ConfigurationException {
        for (CommitMessageInspectionDetails details : this.myToolDetails.values()) {
            details.apply();
        }
        this.myModifiableModel.commit();
        this.reset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/CommitMessageInspectionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/CommitMessageInspectionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDetails";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInspectionsTreeRenderer
    extends InspectionsConfigTreeRenderer {
        private MyInspectionsTreeRenderer() {
        }

        @Override
        @Nullable
        protected String getFilter() {
            return null;
        }
    }

    private static class MyInspectionTreeNode
    extends InspectionConfigTreeNode {
        public MyInspectionTreeNode(@NotNull ToolDescriptors descriptors) {
            if (descriptors == null) {
                MyInspectionTreeNode.$$$reportNull$$$0(0);
            }
            this.setUserObject(descriptors);
        }

        @Override
        @NotNull
        public Descriptor getDefaultDescriptor() {
            Descriptor descriptor2 = (Descriptor)ObjectUtils.notNull((Object)super.getDefaultDescriptor());
            if (descriptor2 == null) {
                MyInspectionTreeNode.$$$reportNull$$$0(1);
            }
            return descriptor2;
        }

        @Override
        @NotNull
        public ToolDescriptors getDescriptors() {
            ToolDescriptors toolDescriptors = (ToolDescriptors)ObjectUtils.notNull((Object)super.getDescriptors());
            if (toolDescriptors == null) {
                MyInspectionTreeNode.$$$reportNull$$$0(2);
            }
            return toolDescriptors;
        }

        @Override
        public boolean isProperSetting() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/CommitMessageInspectionsPanel$MyInspectionTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/CommitMessageInspectionsPanel$MyInspectionTreeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyInspectionsTableSettings
    extends InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings {
        public MyInspectionsTableSettings(@NotNull Project project2, InspectionConfigTreeNode root) {
            if (project2 == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(1);
            }
            super(root, project2);
        }

        @Override
        @NotNull
        protected InspectionProfileImpl getInspectionProfile() {
            InspectionProfileModifiableModel inspectionProfileModifiableModel = CommitMessageInspectionsPanel.this.myModifiableModel;
            if (inspectionProfileModifiableModel == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(2);
            }
            return inspectionProfileModifiableModel;
        }

        @Override
        protected void onChanged(@NotNull InspectionConfigTreeNode node) {
            if (node == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void updateRightPanel() {
            CommitMessageInspectionsPanel.this.updateDetailsPanel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/CommitMessageInspectionsPanel$MyInspectionsTableSettings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/CommitMessageInspectionsPanel$MyInspectionsTableSettings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInspectionProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

