/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserRegistryImpl
implements Disposable,
VcsUserRegistry {
    private static final File USER_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-users");
    private static final Logger LOG = Logger.getInstance(VcsUserRegistryImpl.class);
    private static final int STORAGE_VERSION = 2;
    private static final PersistentEnumeratorBase.DataFilter ACCEPT_ALL_DATA_FILTER = id -> true;
    @Nullable
    private final PersistentEnumeratorBase<VcsUser> myPersistentEnumerator;
    @NotNull
    private final Interner<VcsUser> myInterner;

    VcsUserRegistryImpl(@NotNull Project project2) {
        if (project2 == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(0);
        }
        File mapFile = new File(USER_CACHE_APP_DIR, project2.getLocationHash() + "." + 2);
        this.myPersistentEnumerator = this.initEnumerator(mapFile);
        this.myInterner = new Interner();
    }

    @Nullable
    private PersistentEnumeratorBase<VcsUser> initEnumerator(@NotNull File mapFile) {
        if (mapFile == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(1);
        }
        try {
            return (PersistentEnumeratorBase)IOUtil.openCleanOrResetBroken(() -> {
                if (mapFile == null) {
                    VcsUserRegistryImpl.$$$reportNull$$$0(10);
                }
                return new PersistentBTreeEnumerator(mapFile, (KeyDescriptor)new MyDescriptor(), Page.PAGE_SIZE, null, 2);
            }, (File)mapFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public VcsUser createUser(@NotNull String name2, @NotNull String email) {
        if (name2 == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(2);
        }
        if (email == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(3);
        }
        Interner<VcsUser> interner = this.myInterner;
        // MONITORENTER : interner
        VcsUser vcsUser = (VcsUser)this.myInterner.intern((Object)new VcsUserImpl(name2, email));
        // MONITOREXIT : interner
        if (vcsUser != null) return vcsUser;
        VcsUserRegistryImpl.$$$reportNull$$$0(4);
        return vcsUser;
    }

    public void addUser(@NotNull VcsUser user) {
        if (user == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(5);
        }
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.enumerate((Object)user);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void addUsers(@NotNull Collection<VcsUser> users) {
        if (users == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(6);
        }
        for (VcsUser user : users) {
            this.addUser(user);
        }
    }

    @NotNull
    public Set<VcsUser> getUsers() {
        HashSet hashSet;
        try {
            Set users = this.myPersistentEnumerator != null ? this.myPersistentEnumerator.getAllDataObjects(ACCEPT_ALL_DATA_FILTER) : Collections.emptySet();
            hashSet = ContainerUtil.newHashSet(users);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Set<VcsUser> set2 = Collections.emptySet();
            if (set2 == null) {
                VcsUserRegistryImpl.$$$reportNull$$$0(8);
            }
            return set2;
        }
        if (hashSet == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    public void flush() {
        if (this.myPersistentEnumerator != null) {
            this.myPersistentEnumerator.force();
        }
    }

    public void dispose() {
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public int getUserId(@NotNull VcsUser user) throws IOException {
        if (user == null) {
            VcsUserRegistryImpl.$$$reportNull$$$0(9);
        }
        if (this.myPersistentEnumerator != null) {
            return this.myPersistentEnumerator.enumerate((Object)user);
        }
        return -1;
    }

    @Nullable
    public VcsUser getUserById(Integer userId) throws IOException {
        if (this.myPersistentEnumerator != null) {
            return (VcsUser)this.myPersistentEnumerator.valueOf(userId.intValue());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "email";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsUserRegistryImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsUserRegistryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUser";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initEnumerator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUser";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addUser";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addUsers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initEnumerator$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDescriptor
    implements KeyDescriptor<VcsUser> {
        private MyDescriptor() {
        }

        public void save(@NotNull DataOutput out, VcsUser value2) throws IOException {
            if (out == null) {
                MyDescriptor.$$$reportNull$$$0(0);
            }
            IOUtil.writeUTF((DataOutput)out, (String)value2.getName());
            IOUtil.writeUTF((DataOutput)out, (String)value2.getEmail());
        }

        public VcsUser read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyDescriptor.$$$reportNull$$$0(1);
            }
            String name2 = IOUtil.readUTF((DataInput)in);
            String email = IOUtil.readUTF((DataInput)in);
            return VcsUserRegistryImpl.this.createUser(name2, email);
        }

        public int getHashCode(VcsUser value2) {
            return value2.hashCode();
        }

        public boolean isEqual(VcsUser val1, VcsUser val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsUserRegistryImpl$MyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

