/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUtil {
    public static final int MAX_SELECTED_COMMITS = 1000;

    @NotNull
    public static Map<VirtualFile, Set<VcsRef>> groupRefsByRoot(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(0);
        }
        Map<VirtualFile, Set<VcsRef>> map = VcsLogUtil.groupByRoot(refs, VcsRef::getRoot);
        if (map == null) {
            VcsLogUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    private static <T> Map<VirtualFile, Set<T>> groupByRoot(@NotNull Collection<T> items, @NotNull Function<T, VirtualFile> rootGetter) {
        if (items == null) {
            VcsLogUtil.$$$reportNull$$$0(2);
        }
        if (rootGetter == null) {
            VcsLogUtil.$$$reportNull$$$0(3);
        }
        TreeMap<VirtualFile, Set<T>> map = new TreeMap<VirtualFile, Set<T>>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (T item : items) {
            VirtualFile root = (VirtualFile)rootGetter.fun(item);
            Set set2 = (Set)map.get(root);
            if (set2 == null) {
                set2 = ContainerUtil.newHashSet();
                map.put(root, set2);
            }
            set2.add(item);
        }
        TreeMap<VirtualFile, Set<T>> treeMap = map;
        if (treeMap == null) {
            VcsLogUtil.$$$reportNull$$$0(4);
        }
        return treeMap;
    }

    @NotNull
    public static List<Integer> getVisibleCommits(final @NotNull VisibleGraph<Integer> visibleGraph) {
        if (visibleGraph == null) {
            VcsLogUtil.$$$reportNull$$$0(5);
        }
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return (Integer)visibleGraph.getRowInfo(index).getCommit();
            }

            @Override
            public int size() {
                return visibleGraph.getVisibleCommitCount();
            }
        };
        if (abstractList == null) {
            VcsLogUtil.$$$reportNull$$$0(6);
        }
        return abstractList;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            VcsLogUtil.$$$reportNull$$$0(7);
        }
        if (root2 == null) {
            VcsLogUtil.$$$reportNull$$$0(8);
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Set<VirtualFile> collectRoots(@NotNull Collection<FilePath> files, @NotNull Set<VirtualFile> roots) {
        if (files == null) {
            VcsLogUtil.$$$reportNull$$$0(9);
        }
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(10);
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        List sortedRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
        for (FilePath filePath : files) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile != null && roots.contains(virtualFile)) {
                selectedRoots.add(virtualFile);
            } else {
                VirtualFile candidateAncestorRoot = null;
                for (VirtualFile root : sortedRoots) {
                    if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false)) continue;
                    candidateAncestorRoot = root;
                }
                if (candidateAncestorRoot != null) {
                    selectedRoots.add(candidateAncestorRoot);
                }
            }
            if (virtualFile == null) continue;
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)root, (boolean)false)) continue;
                selectedRoots.add(root);
            }
        }
        HashSet<VirtualFile> hashSet = selectedRoots;
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        if (roots == null) {
            VcsLogUtil.$$$reportNull$$$0(12);
        }
        if (rootFilter == null && structureFilter == null) {
            HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(roots);
            if (hashSet == null) {
                VcsLogUtil.$$$reportNull$$$0(13);
            }
            return hashSet;
        }
        Set<VirtualFile> fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        Set<VirtualFile> fromStructureFilter = structureFilter != null ? VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet<VirtualFile>(roots)) : roots;
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @NotNull
    public static Set<FilePath> getFilteredFilesForRoot(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection) {
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(15);
        }
        if (filterCollection == null) {
            VcsLogUtil.$$$reportNull$$$0(16);
        }
        if (filterCollection.getStructureFilter() == null) {
            Set<FilePath> set2 = Collections.emptySet();
            if (set2 == null) {
                VcsLogUtil.$$$reportNull$$$0(17);
            }
            return set2;
        }
        Collection files = filterCollection.getStructureFilter().getFiles();
        HashSet<FilePath> hashSet = new HashSet<FilePath>(ContainerUtil.filter((Collection)files, filePath -> {
            VirtualFile virtualFile;
            if (root == null) {
                VcsLogUtil.$$$reportNull$$$0(40);
            }
            return root.equals(virtualFile = filePath.getVirtualFile()) || FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)filePath.getIOFile(), (boolean)false);
        }));
        if (hashSet == null) {
            VcsLogUtil.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @NotNull
    public static <T> List<T> collectFirstPack(@NotNull List<T> list2, int max) {
        if (list2 == null) {
            VcsLogUtil.$$$reportNull$$$0(19);
        }
        List<T> list3 = list2.subList(0, Math.min(list2.size(), max));
        if (list3 == null) {
            VcsLogUtil.$$$reportNull$$$0(20);
        }
        return list3;
    }

    @NotNull
    public static Set<VirtualFile> getVisibleRoots(@NotNull VcsLogUi logUi) {
        if (logUi == null) {
            VcsLogUtil.$$$reportNull$$$0(21);
        }
        VcsLogFilterCollection filters = logUi.getFilterUi().getFilters();
        Set<VirtualFile> roots = logUi.getDataPack().getLogProviders().keySet();
        Set<VirtualFile> set2 = VcsLogUtil.getAllVisibleRoots(roots, filters.getRootFilter(), filters.getStructureFilter());
        if (set2 == null) {
            VcsLogUtil.$$$reportNull$$$0(22);
        }
        return set2;
    }

    @Nullable
    public static String getSingleFilteredBranch(@NotNull VcsLogBranchFilter filter2, @NotNull VcsLogRefs refs) {
        if (filter2 == null) {
            VcsLogUtil.$$$reportNull$$$0(23);
        }
        if (refs == null) {
            VcsLogUtil.$$$reportNull$$$0(24);
        }
        String branchName = null;
        HashSet checkedRoots = ContainerUtil.newHashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!filter2.matches(branch.getName())) continue;
            if (branchName == null) {
                branchName = branch.getName();
            } else if (!branch.getName().equals(branchName)) {
                return null;
            }
            if (checkedRoots.contains(branch.getRoot())) {
                return null;
            }
            checkedRoots.add(branch.getRoot());
        }
        return branchName;
    }

    public static void triggerUsage(@NotNull AnActionEvent e) {
        String text2;
        if (e == null) {
            VcsLogUtil.$$$reportNull$$$0(25);
        }
        if ((text2 = e.getPresentation().getText()) != null) {
            VcsLogUtil.triggerUsage(text2);
        }
    }

    public static void triggerUsage(@NotNull String text2) {
        if (text2 == null) {
            VcsLogUtil.$$$reportNull$$$0(26);
        }
        UsageTrigger.trigger("vcs.log." + ConvertUsagesUtil.ensureProperKey(text2).replace(" ", ""));
    }

    public static boolean maybeRegexp(@NotNull String text2) {
        if (text2 == null) {
            VcsLogUtil.$$$reportNull$$$0(27);
        }
        return StringUtil.containsAnyChar((String)text2, (String)"()[]{}.*?+^$\\|");
    }

    @NotNull
    public static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(28);
        }
        TextRevisionNumber textRevisionNumber = new TextRevisionNumber(hash.asString(), hash.toShortString());
        if (textRevisionNumber == null) {
            VcsLogUtil.$$$reportNull$$$0(29);
        }
        return textRevisionNumber;
    }

    @NotNull
    public static VcsFullCommitDetails getDetails(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (data == null) {
            VcsLogUtil.$$$reportNull$$$0(30);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(31);
        }
        if (hash == null) {
            VcsLogUtil.$$$reportNull$$$0(32);
        }
        VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(VcsLogUtil.getDetails(data.getLogProvider(root), root, Collections.singletonList(hash.asString()))));
        if (vcsFullCommitDetails == null) {
            VcsLogUtil.$$$reportNull$$$0(33);
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> getDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (logProvider == null) {
            VcsLogUtil.$$$reportNull$$$0(34);
        }
        if (root == null) {
            VcsLogUtil.$$$reportNull$$$0(35);
        }
        if (hashes == null) {
            VcsLogUtil.$$$reportNull$$$0(36);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        logProvider.readFullDetails(root, hashes, result2::add);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public static CommittedChangeListForRevision createCommittedChangeList(@NotNull VcsFullCommitDetails detail) {
        if (detail == null) {
            VcsLogUtil.$$$reportNull$$$0(38);
        }
        CommittedChangeListForRevision committedChangeListForRevision = new CommittedChangeListForRevision(detail.getSubject(), detail.getFullMessage(), VcsUserUtil.getShortPresentation(detail.getCommitter()), new Date(detail.getCommitTime()), detail.getChanges(), (VcsRevisionNumber)VcsLogUtil.convertToRevisionNumber((Hash)detail.getId()));
        if (committedChangeListForRevision == null) {
            VcsLogUtil.$$$reportNull$$$0(39);
        }
        return committedChangeListForRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleGraph";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 15: 
            case 31: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRefsByRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleCommits";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVisibleRoots";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFilesForRoot";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFirstPack";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRoots";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRevisionNumber";
                break;
            }
            case 33: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommittedChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "groupRefsByRoot";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 39: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleCommits";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareRoots";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleRoots";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFilesForRoot";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectFirstPack";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRoots";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSingleFilteredBranch";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "triggerUsage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "maybeRegexp";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertToRevisionNumber";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createCommittedChangeList";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFilteredFilesForRoot$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

