/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterModel<Filter extends VcsLogFilter> {
    @NotNull
    private final String myName;
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Computable<VcsLogDataPack> myDataPackProvider;
    @NotNull
    private final Collection<Runnable> mySetFilterListeners;
    @Nullable
    private Filter myFilter;

    FilterModel(@NotNull String name2, @NotNull Computable<VcsLogDataPack> provider, @NotNull MainVcsLogUiProperties uiProperties) {
        if (name2 == null) {
            FilterModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            FilterModel.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            FilterModel.$$$reportNull$$$0(2);
        }
        this.mySetFilterListeners = ContainerUtil.newArrayList();
        this.myName = name2;
        this.myUiProperties = uiProperties;
        this.myDataPackProvider = provider;
    }

    void setFilter(@Nullable Filter filter2) {
        this.myFilter = filter2;
        this.saveFilter(filter2);
        for (Runnable listener2 : this.mySetFilterListeners) {
            listener2.run();
        }
    }

    protected void saveFilter(@Nullable Filter filter2) {
        this.myUiProperties.saveFilterValues(this.myName, filter2 == null ? null : this.getFilterValues(filter2));
    }

    @Nullable
    Filter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = this.getLastFilter();
        }
        return this.myFilter;
    }

    @Nullable
    protected abstract Filter createFilter(@NotNull List<String> var1);

    @NotNull
    protected abstract List<String> getFilterValues(@NotNull Filter var1);

    @Nullable
    protected Filter getLastFilter() {
        List<String> values = this.myUiProperties.getFilterValues(this.myName);
        if (values != null) {
            return this.createFilter(values);
        }
        return null;
    }

    @NotNull
    VcsLogDataPack getDataPack() {
        VcsLogDataPack vcsLogDataPack = (VcsLogDataPack)this.myDataPackProvider.compute();
        if (vcsLogDataPack == null) {
            FilterModel.$$$reportNull$$$0(3);
        }
        return vcsLogDataPack;
    }

    void addSetFilterListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FilterModel.$$$reportNull$$$0(4);
        }
        this.mySetFilterListeners.add(runnable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/FilterModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/FilterModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSetFilterListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

