/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.VcsLogFileFilter;
import com.intellij.vcs.log.impl.VcsLogRootFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsStructureChooser;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureFilterPopupComponent
extends FilterPopupComponent<VcsLogFileFilter> {
    private static final int FILTER_LABEL_LENGTH = 30;
    private static final int CHECKBOX_ICON_SIZE = 15;
    public static final FileByNameComparator FILE_BY_NAME_COMPARATOR = new FileByNameComparator();
    public static final FilePathByPathComparator FILE_PATH_BY_PATH_COMPARATOR = new FilePathByPathComparator();
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final FixedSizeQueue<VcsLogStructureFilter> myHistory;

    public StructureFilterPopupComponent(@NotNull FilterModel<VcsLogFileFilter> filterModel, @NotNull VcsLogColorManager colorManager) {
        if (filterModel == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(1);
        }
        super("Paths", filterModel);
        this.myHistory = new FixedSizeQueue(5);
        this.myColorManager = colorManager;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogFileFilter filter2) {
        if (filter2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(2);
        }
        Collection<Object> roots = filter2.getRootFilter() == null ? this.getAllRoots() : filter2.getRootFilter().getRoots();
        Set<FilePath> files = filter2.getStructureFilter() == null ? Collections.emptySet() : filter2.getStructureFilter().getFiles();
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(this.getAllRoots(), filter2.getRootFilter(), filter2.getStructureFilter());
        if (files.isEmpty()) {
            String string = StructureFilterPopupComponent.getTextFromRoots(roots, visibleRoots.size() == this.getAllRoots().size());
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = StructureFilterPopupComponent.getTextFromFilePaths(files, "folders", false);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getTextFromRoots(@NotNull Collection<VirtualFile> files, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(5);
        }
        String string = StructureFilterPopupComponent.getText(files, "roots", FILE_BY_NAME_COMPARATOR, VirtualFile::getName, full);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String getTextFromFilePaths(@NotNull Collection<FilePath> files, @NotNull String category, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(7);
        }
        if (category == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(8);
        }
        String string = StructureFilterPopupComponent.getText(files, category, FILE_PATH_BY_PATH_COMPARATOR, file2 -> StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)30), full);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static <F> String getText(@NotNull Collection<F> files, @NotNull String category, @NotNull Comparator<F> comparator2, @NotNull NotNullFunction<F, String> getText, boolean full) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(10);
        }
        if (category == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(11);
        }
        if (comparator2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(12);
        }
        if (getText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(13);
        }
        if (full) {
            if ("All" == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(14);
            }
            return "All";
        }
        if (files.isEmpty()) {
            String string = "No " + category;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(15);
            }
            return string;
        }
        F firstFile = Collections.min(files, comparator2);
        String firstFileName = (String)getText.fun(firstFile);
        if (files.size() == 1) {
            String string = firstFileName;
            if (string == null) {
                StructureFilterPopupComponent.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = firstFileName + " + " + (files.size() - 1);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogFileFilter filter2) {
        if (filter2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(18);
        }
        return this.getToolTip(filter2.getRootFilter() == null ? this.getAllRoots() : filter2.getRootFilter().getRoots(), filter2.getStructureFilter() == null ? Collections.emptySet() : filter2.getStructureFilter().getFiles());
    }

    @NotNull
    private String getToolTip(@NotNull Collection<VirtualFile> roots, @NotNull Collection<FilePath> files) {
        if (roots == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(19);
        }
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(20);
        }
        String tooltip = "";
        if (roots.isEmpty()) {
            tooltip = tooltip + "No Roots Selected";
        } else if (roots.size() != this.getAllRoots().size()) {
            tooltip = tooltip + "Roots:\n" + StructureFilterPopupComponent.getTooltipTextForRoots(roots);
        }
        if (!files.isEmpty()) {
            if (!tooltip.isEmpty()) {
                tooltip = tooltip + "\n";
            }
            tooltip = tooltip + "Folders:\n" + StructureFilterPopupComponent.getTooltipTextForFilePaths(files);
        }
        String string = tooltip;
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String getTooltipTextForRoots(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(22);
        }
        String string = StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_BY_NAME_COMPARATOR, VirtualFile::getName);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String getTooltipTextForFilePaths(@NotNull Collection<FilePath> files) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(24);
        }
        String string = StructureFilterPopupComponent.getTooltipTextForFiles(files, FILE_PATH_BY_PATH_COMPARATOR, FilePath::getPresentableUrl);
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static <F> String getTooltipTextForFiles(@NotNull Collection<F> files, @NotNull Comparator<F> comparator2, @NotNull NotNullFunction<F, String> getText) {
        if (files == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(26);
        }
        if (comparator2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(27);
        }
        if (getText == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(28);
        }
        List filesToDisplay = ContainerUtil.sorted(files, comparator2);
        if (files.size() > 10) {
            filesToDisplay = filesToDisplay.subList(0, 10);
        }
        String tooltip = StringUtil.join((Collection)filesToDisplay, getText, (String)"\n");
        if (files.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        String string = tooltip;
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Set<VirtualFile> roots = this.getAllRoots();
        ArrayList<SelectVisibleRootAction> rootActions = new ArrayList<SelectVisibleRootAction>();
        if (this.myColorManager.isMultipleRoots()) {
            for (VirtualFile root : ContainerUtil.sorted(roots, (Comparator)FILE_BY_NAME_COMPARATOR)) {
                rootActions.add(new SelectVisibleRootAction(root));
            }
        }
        ArrayList<SelectFromHistoryAction> structureActions = new ArrayList<SelectFromHistoryAction>();
        for (VcsLogStructureFilter filter2 : this.myHistory) {
            structureActions.add(new SelectFromHistoryAction(filter2));
        }
        if (roots.size() > 15) {
            return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Recent"), new DefaultActionGroup(structureActions), new Separator("Roots"), new DefaultActionGroup(rootActions)});
        }
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectFoldersAction(), new Separator("Roots"), new DefaultActionGroup(rootActions), new Separator("Recent"), new DefaultActionGroup(structureActions)});
    }

    private Set<VirtualFile> getAllRoots() {
        return this.myFilterModel.getDataPack().getLogProviders().keySet();
    }

    private boolean isVisible(@NotNull VirtualFile root) {
        VcsLogFileFilter filter2;
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(30);
        }
        if ((filter2 = (VcsLogFileFilter)this.myFilterModel.getFilter()) != null && filter2.getRootFilter() != null) {
            return filter2.getRootFilter().getRoots().contains(root);
        }
        return true;
    }

    private void setVisible(@NotNull VirtualFile root, boolean visible) {
        VcsLogRootFilter rootFilter;
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(31);
        }
        Set<VirtualFile> roots = this.getAllRoots();
        VcsLogFileFilter previousFilter = (VcsLogFileFilter)this.myFilterModel.getFilter();
        VcsLogRootFilter vcsLogRootFilter = rootFilter = previousFilter != null ? previousFilter.getRootFilter() : null;
        Collection<Object> visibleRoots = rootFilter == null ? (visible ? roots : ContainerUtil.subtract(roots, Collections.singleton(root))) : (visible ? ContainerUtil.union(new HashSet(rootFilter.getRoots()), Collections.singleton(root)) : ContainerUtil.subtract((Collection)rootFilter.getRoots(), Collections.singleton(root)));
        this.myFilterModel.setFilter(new VcsLogFileFilter(null, new VcsLogRootFilterImpl(visibleRoots)));
    }

    private void setVisibleOnly(@NotNull VirtualFile root) {
        if (root == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(32);
        }
        this.myFilterModel.setFilter(new VcsLogFileFilter(null, new VcsLogRootFilterImpl(Collections.singleton(root))));
    }

    @NotNull
    private static String getStructureActionText(@NotNull VcsLogStructureFilter filter2) {
        if (filter2 == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(33);
        }
        String string = StructureFilterPopupComponent.getTextFromFilePaths(filter2.getFiles(), "items", filter2.getFiles().isEmpty());
        if (string == null) {
            StructureFilterPopupComponent.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: 
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFromRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFromFilePaths";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolTip";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForRoots";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForFilePaths";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTextForFiles";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromFilePaths";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForRoots";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFilePaths";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipTextForFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setVisible";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setVisibleOnly";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStructureActionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FixedSizeQueue<T>
    implements Iterable<T> {
        @NotNull
        private final LinkedList<T> myQueue = new LinkedList();
        private final int maxSize;

        public FixedSizeQueue(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator iterator = ContainerUtil.reverse(this.myQueue).iterator();
            if (iterator == null) {
                FixedSizeQueue.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        public void add(T t) {
            this.myQueue.add(t);
            if (this.myQueue.size() > this.maxSize) {
                this.myQueue.poll();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$FixedSizeQueue", "iterator"));
        }
    }

    private class SelectFromHistoryAction
    extends ToggleAction {
        @NotNull
        private final VcsLogStructureFilter myFilter;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final Icon myEmptyIcon;

        private SelectFromHistoryAction(VcsLogStructureFilter filter2) {
            if (filter2 == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(0);
            }
            super(StructureFilterPopupComponent.getStructureActionText(filter2), StructureFilterPopupComponent.getTooltipTextForFilePaths(filter2.getFiles()).replace("\n", " "), null);
            this.myFilter = filter2;
            this.myIcon = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, 15, 15));
            this.myEmptyIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15));
        }

        public boolean isSelected(AnActionEvent e) {
            return StructureFilterPopupComponent.this.myFilterModel.getFilter() != null && ((VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter()).getStructureFilter() == this.myFilter;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            StructureFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogFileFilter(this.myFilter, null));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFromHistoryAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            if (this.isSelected(e)) {
                presentation.setIcon(this.myIcon);
            } else {
                presentation.setIcon(this.myEmptyIcon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFromHistoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SelectFoldersAction
    extends DumbAwareAction {
        public static final String STRUCTURE_FILTER_TEXT = "Select Folders...";

        SelectFoldersAction() {
            super(STRUCTURE_FILTER_TEXT);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectFoldersAction.$$$reportNull$$$0(0);
            }
            Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            VcsLogDataPack dataPack = StructureFilterPopupComponent.this.myFilterModel.getDataPack();
            VcsLogFileFilter filter2 = (VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter();
            Collection<Object> files = filter2 == null || filter2.getStructureFilter() == null ? Collections.emptySet() : ContainerUtil.mapNotNull((Collection)filter2.getStructureFilter().getFiles(), FilePath::getVirtualFile);
            VcsStructureChooser chooser = new VcsStructureChooser(project2, "Select Files or Folders to Filter by", files, new ArrayList<VirtualFile>(dataPack.getLogProviders().keySet()));
            if (chooser.showAndGet()) {
                VcsLogStructureFilterImpl structureFilter = new VcsLogStructureFilterImpl((Set<VirtualFile>)new HashSet<VirtualFile>(chooser.getSelectedFiles()));
                StructureFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogFileFilter(structureFilter, null));
                StructureFilterPopupComponent.this.myHistory.add(structureFilter);
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectFoldersAction", "actionPerformed"));
        }
    }

    private static class CheckboxColorIcon
    extends ColorIcon {
        private final int mySize;
        private boolean mySelected;
        private SizedIcon mySizedIcon;

        public CheckboxColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                CheckboxColorIcon.$$$reportNull$$$0(0);
            }
            super(size, color);
            this.mySelected = false;
            this.mySize = size;
            this.mySizedIcon = new SizedIcon(PlatformIcons.CHECK_ICON_SMALL, this.mySize, this.mySize);
        }

        public void prepare(boolean selected) {
            this.mySelected = selected;
        }

        public CheckboxColorIcon withIconPreScaled(boolean preScaled) {
            this.mySizedIcon = (SizedIcon)this.mySizedIcon.withIconPreScaled(preScaled);
            return (CheckboxColorIcon)super.withIconPreScaled(preScaled);
        }

        public void paintIcon(Component component, Graphics g, int i, int j) {
            super.paintIcon(component, g, i, j);
            if (this.mySelected) {
                this.mySizedIcon.paintIcon(component, g, i, j);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$CheckboxColorIcon", "<init>"));
        }
    }

    private class SelectVisibleRootAction
    extends ToggleAction
    implements DumbAware,
    KeepingPopupOpenAction {
        @NotNull
        private final CheckboxColorIcon myIcon;
        @NotNull
        private final VirtualFile myRoot;

        private SelectVisibleRootAction(VirtualFile root) {
            if (root == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(0);
            }
            super(root.getName(), root.getPresentableUrl(), null);
            this.myRoot = root;
            this.myIcon = (CheckboxColorIcon)JBUI.scale((JBUI.JBIcon)new CheckboxColorIcon(15, (Color)VcsLogGraphTable.getRootBackgroundColor(this.myRoot, StructureFilterPopupComponent.this.myColorManager)));
            this.getTemplatePresentation().setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)15)));
        }

        public boolean isSelected(AnActionEvent e) {
            return StructureFilterPopupComponent.this.isVisible(this.myRoot);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (!this.isEnabled()) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else if ((e.getModifiers() & this.getMask()) != 0) {
                StructureFilterPopupComponent.this.setVisibleOnly(this.myRoot);
            } else {
                StructureFilterPopupComponent.this.setVisible(this.myRoot, state);
            }
        }

        @JdkConstants.InputEventMask
        private int getMask() {
            return SystemInfo.isMac ? 4 : 2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectVisibleRootAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            this.updateIcon();
            e.getPresentation().setIcon((Icon)((Object)this.myIcon));
            e.getPresentation().putClientProperty("ToolTipText", (Object)(KeyEvent.getKeyModifiersText(this.getMask()) + "+Click to see only \"" + e.getPresentation().getText() + "\""));
        }

        private void updateIcon() {
            this.myIcon.prepare(StructureFilterPopupComponent.this.isVisible(this.myRoot) && this.isEnabled());
        }

        private boolean isEnabled() {
            return StructureFilterPopupComponent.this.myFilterModel.getFilter() == null || ((VcsLogFileFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter()).getStructureFilter() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectVisibleRootAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilePathByPathComparator
    implements Comparator<FilePath> {
        private FilePathByPathComparator() {
        }

        @Override
        public int compare(FilePath o1, FilePath o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    }

    private static class FileByNameComparator
    implements Comparator<VirtualFile> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(VirtualFile o1, VirtualFile o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

