/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UI;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.MergedChangeDiffRequestProvider;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final BiFunction<Hash, VirtualFile, VcsShortCommitDetails> myDataGetter;
    @NotNull
    private final VcsLogUiProperties.PropertiesChangeListener myListener;
    @Nullable
    private VcsFullCommitDetails myDetail;
    @Nullable
    private VirtualFile myRoot;
    @NotNull
    private final List<Change> myChanges;
    @NotNull
    private final Map<Hash, Set<Change>> myChangesToParents;

    public VcsLogChangesBrowser(@NotNull Project project2, @NotNull MainVcsLogUiProperties uiProperties, @NotNull BiFunction<Hash, VirtualFile, VcsShortCommitDetails> getter, @NotNull Disposable parent) {
        if (project2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(1);
        }
        if (getter == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(3);
        }
        super(project2, false, false);
        this.myChanges = ContainerUtil.newArrayList();
        this.myChangesToParents = ContainerUtil.newHashMap();
        this.myProject = project2;
        this.myUiProperties = uiProperties;
        this.myDataGetter = getter;
        this.myListener = new VcsLogUiProperties.PropertiesChangeListener(){

            @Override
            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS.equals(property)) {
                    VcsLogChangesBrowser.this.myViewer.rebuildTree();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$1", "onPropertyChanged"));
            }
        };
        this.myUiProperties.addChangeListener(this.myListener);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.init();
        this.getViewerScrollPane().setBorder(IdeBorderFactory.createBorder((int)2));
        this.myViewer.rebuildTree();
    }

    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myListener);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>(super.createToolbarActions());
        result2.add(ActionManager.getInstance().getAction("Vcs.RepositoryChangesBrowserToolbar"));
        result2.add(ActionManager.getInstance().getAction("Vcs.Log.QuickChangesViewSettings"));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void resetSelectedDetails() {
        this.myDetail = null;
        this.myRoot = null;
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myViewer.setEmptyText("");
        this.myViewer.rebuildTree();
    }

    public void setSelectedDetails(@NotNull List<VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(5);
        }
        this.myDetail = null;
        this.myRoot = null;
        this.myChanges.clear();
        this.myChangesToParents.clear();
        if (detailsList.isEmpty()) {
            this.myViewer.setEmptyText("No commits selected");
        } else if (detailsList.size() == 1) {
            this.myDetail = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(detailsList));
            this.myRoot = this.myDetail.getRoot();
            this.myChanges.addAll(this.myDetail.getChanges());
            if (this.myDetail.getParents().size() > 1) {
                for (int i = 0; i < this.myDetail.getParents().size(); ++i) {
                    THashSet changesSet = ContainerUtil.newIdentityTroveSet((Collection)this.myDetail.getChanges(i));
                    this.myChangesToParents.put((Hash)this.myDetail.getParents().get(i), (Set<Change>)changesSet);
                }
            }
            if (this.myChanges.isEmpty() && this.myDetail.getParents().size() > 1) {
                this.myViewer.getEmptyText().setText("No merged conflicts.").appendSecondaryText("Show changes to parents", VcsLogChangesBrowser.getLinkAttributes(), e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS, true));
            } else {
                this.myViewer.setEmptyText("");
            }
        } else {
            ArrayList changes = ContainerUtil.newArrayList();
            List detailsListReversed = ContainerUtil.reverse(detailsList);
            for (VcsFullCommitDetails detail : detailsListReversed) {
                changes.addAll(detail.getChanges());
            }
            this.myChanges.addAll(CommittedChangesTreeBrowser.zipChanges(changes));
            this.myViewer.setEmptyText("");
        }
        this.myViewer.rebuildTree();
    }

    @NotNull
    private static SimpleTextAttributes getLinkAttributes() {
        SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, UI.getColor((String)"link.foreground"));
        if (simpleTextAttributes == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(6);
        }
        return simpleTextAttributes;
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel(boolean showFlatten) {
        MyTreeModelBuilder builder = new MyTreeModelBuilder(showFlatten);
        builder.setChanges(this.myChanges, null);
        if (this.isShowChangesFromParents() && !this.myChangesToParents.isEmpty()) {
            if (this.myChanges.isEmpty()) {
                builder.addEmptyTextNode("No merged conflicts");
            }
            for (Hash hash : this.myChangesToParents.keySet()) {
                Collection changesFromParent = this.myChangesToParents.get(hash);
                if (changesFromParent.isEmpty()) continue;
                builder.addChangesFromParentNode(changesFromParent, hash, this.myRoot);
            }
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        if (defaultTreeModel == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(7);
        }
        return defaultTreeModel;
    }

    private boolean isShowChangesFromParents() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) != false;
    }

    @NotNull
    public List<Change> getAllChanges() {
        List<Change> list2 = this.myChanges;
        if (list2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(9);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            if (this.myRoot != null) {
                AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(this.myRoot);
                return vcs == null ? null : vcs.getKeyInstanceMethod();
            }
            List<Change> selectedChanges = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
            Set abstractVcs = ChangesUtil.getAffectedVcses(selectedChanges, (Project)this.myProject);
            if (abstractVcs.size() == 1) {
                return ((AbstractVcs)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)abstractVcs))).getKeyInstanceMethod();
            }
            return null;
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        MergedChange mergedChange;
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(10);
        }
        if (userObject instanceof MergedChange && (mergedChange = (MergedChange)((Object)userObject)).getSourceChanges().size() == 2) {
            return new MergedChangeDiffRequestProvider.MyProducer(this.myProject, mergedChange);
        }
        if (userObject instanceof Change) {
            Change change = (Change)userObject;
            if (this.myDetail != null && this.myDetail.getParents().size() > 1) {
                Hash parentHash = null;
                for (Hash hash : this.myChangesToParents.keySet()) {
                    if (!this.myChangesToParents.get(hash).contains(change)) continue;
                    parentHash = hash;
                    break;
                }
                if (parentHash != null && this.myRoot != null) {
                    RootTag tag = new RootTag(parentHash, this.getText(parentHash, this.myRoot));
                    Map<Key, Object> context = Collections.singletonMap(ChangeDiffRequestProducer.TAG_KEY, tag);
                    return ChangeDiffRequestProducer.create(this.myProject, change, context);
                }
            } else {
                return ChangeDiffRequestProducer.create(this.myProject, change);
            }
        }
        return null;
    }

    @NotNull
    private String getText(@NotNull Hash commit, @NotNull VirtualFile root) {
        if (commit == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(11);
        }
        if (root == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(12);
        }
        String text2 = "Changes to " + commit.toShortString();
        VcsShortCommitDetails detail = this.myDataGetter.apply(commit, root);
        if (!(detail instanceof LoadingDetails) || detail instanceof IndexedDetails) {
            text2 = text2 + " " + StringUtil.shortenTextWithEllipsis((String)detail.getSubject(), (int)50, (int)0);
        }
        String string = text2;
        if (string == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedDetails";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootTag {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final String myText;

        public RootTag(@NotNull Hash commit, @NotNull String text2) {
            if (commit == null) {
                RootTag.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                RootTag.$$$reportNull$$$0(1);
            }
            this.myCommit = commit;
            this.myText = text2;
        }

        public String toString() {
            return this.myText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootTag tag = (RootTag)o;
            return Objects.equals(this.myCommit, tag.myCommit);
        }

        public int hashCode() {
            return Objects.hash(this.myCommit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$RootTag";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChangesBrowserParentNode
    extends ChangesBrowserNode {
        protected ChangesBrowserParentNode(@NotNull Hash parentCommit, VirtualFile root) {
            if (parentCommit == null) {
                ChangesBrowserParentNode.$$$reportNull$$$0(0);
            }
            if (root == null) {
                ChangesBrowserParentNode.$$$reportNull$$$0(1);
            }
            super(VcsLogChangesBrowser.this.getText(parentCommit, root));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentCommit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$ChangesBrowserParentNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ChangesBrowserEmptyTextNode
    extends ChangesBrowserNode {
        protected ChangesBrowserEmptyTextNode(@NotNull String text2) {
            if (text2 == null) {
                ChangesBrowserEmptyTextNode.$$$reportNull$$$0(0);
            }
            super(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$ChangesBrowserEmptyTextNode", "<init>"));
        }
    }

    private class MyTreeModelBuilder
    extends TreeModelBuilder {
        public MyTreeModelBuilder(boolean showFlatten) {
            super(VcsLogChangesBrowser.this.myProject, showFlatten);
        }

        public void addEmptyTextNode(@NotNull String text2) {
            if (text2 == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            ChangesBrowserEmptyTextNode textNode = new ChangesBrowserEmptyTextNode(text2);
            textNode.markAsHelperNode();
            this.myModel.insertNodeInto(textNode, this.myRoot, this.myRoot.getChildCount());
        }

        public void addChangesFromParentNode(@NotNull Collection<Change> changes, @NotNull Hash hash, VirtualFile root) {
            if (changes == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            if (hash == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            ChangesBrowserParentNode parentNode = new ChangesBrowserParentNode(hash, root);
            parentNode.markAsHelperNode();
            this.myModel.insertNodeInto(parentNode, this.myRoot, this.myRoot.getChildCount());
            for (Change change : changes) {
                this.insertChangeNode(change, parentNode, this.createChangeNode(change, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hash";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$MyTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addEmptyTextNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangesFromParentNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

