/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class RootCellRenderer
extends JBLabel
implements TableCellRenderer {
    @NotNull
    private final AbstractVcsLogUi myUi;
    @NotNull
    private Color myColor;
    @NotNull
    private Color myBorderColor;
    private boolean isNarrow;

    RootCellRenderer(@NotNull AbstractVcsLogUi ui) {
        if (ui == null) {
            RootCellRenderer.$$$reportNull$$$0(0);
        }
        super("", 0);
        this.myColor = UIUtil.getTableBackground();
        this.myBorderColor = UIUtil.getTableBackground();
        this.isNarrow = true;
        this.myUi = ui;
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.myColor);
        int width = this.getWidth();
        if (this.isNarrow) {
            g.fillRect(0, 0, width - JBUI.scale((int)5), this.myUi.getTable().getRowHeight());
            g.setColor(this.myBorderColor);
            g.fillRect(width - JBUI.scale((int)5), 0, JBUI.scale((int)5), this.myUi.getTable().getRowHeight());
        } else {
            g.fillRect(0, 0, width, this.myUi.getTable().getRowHeight());
        }
        super.paintComponent(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color;
        String text2;
        if (value2 instanceof VirtualFile) {
            VirtualFile root = (VirtualFile)value2;
            int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)this.myUi.getTable().getRowHeight() * 0.5f));
            text2 = row < readableRow ? "" : (row == 0 || !value2.equals(table.getModel().getValueAt(row - 1, column)) || readableRow == row ? root.getName() : "");
            color = VcsLogGraphTable.getRootBackgroundColor(root, this.myUi.getColorManager());
        } else {
            text2 = null;
            color = UIUtil.getTableBackground((boolean)isSelected);
        }
        this.myColor = color;
        Color background = ((VcsLogGraphTable)((Object)table)).getStyle(row, column, hasFocus, isSelected).getBackground();
        assert (background != null);
        this.myBorderColor = background;
        this.setForeground(UIUtil.getTableForeground((boolean)false));
        if (this.myUi.isShowRootNames()) {
            this.setText(text2);
            this.isNarrow = false;
        } else {
            this.setText("");
            this.isNarrow = true;
        }
        return this;
    }

    public void setBackground(Color bg) {
        this.myBorderColor = bg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/table/RootCellRenderer", "<init>"));
    }
}

