/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputForm;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionInputComponent
extends EvaluationInputComponent {
    private final XDebuggerExpressionEditor myExpressionEditor;
    private final ExpressionInputForm myMainForm;

    public ExpressionInputComponent(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable String historyId, @Nullable XSourcePosition sourcePosition, @Nullable XExpression expression2, @NotNull Disposable parentDisposable, boolean showHelp) {
        if (project2 == null) {
            ExpressionInputComponent.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            ExpressionInputComponent.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            ExpressionInputComponent.$$$reportNull$$$0(2);
        }
        super(XDebuggerBundle.message((String)"xdebugger.dialog.title.evaluate.expression", (Object[])new Object[0]));
        this.myMainForm = new ExpressionInputForm();
        BorderLayoutPanel expressionPanel = JBUI.Panels.simplePanel();
        this.myExpressionEditor = new XDebuggerExpressionEditor(project2, editorsProvider, historyId, sourcePosition, expression2 != null ? expression2 : XExpressionImpl.EMPTY_EXPRESSION, false, true, true){

            @Override
            protected JComponent decorate(JComponent component, boolean multiline, boolean showEditor) {
                return component;
            }
        };
        expressionPanel.addToCenter((Component)this.myExpressionEditor.getComponent());
        FixedSizeButton historyButton = new FixedSizeButton(this.myExpressionEditor.getComponent());
        historyButton.setIcon(AllIcons.General.MessageHistory);
        historyButton.setToolTipText(XDebuggerBundle.message((String)"xdebugger.evaluate.history.hint", (Object[])new Object[0]));
        historyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionInputComponent.this.showHistory();
            }
        });
        expressionPanel.addToRight((Component)this.myExpressionEditor.addExpand((JComponent)historyButton));
        JBLabel help = new JBLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.addtowatches.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)XDebuggerEvaluationDialog.ADD_WATCH_KEYSTROKE)}), 4);
        help.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)6, (int)0));
        help.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        help.setFontColor(UIUtil.FontColor.BRIGHTER);
        expressionPanel.addToBottom((Component)help);
        help.setVisible(showHelp);
        this.myMainForm.addExpressionComponent((JComponent)expressionPanel);
        this.myMainForm.addLanguageComponent(this.myExpressionEditor.getLanguageChooser());
        new AnAction("XEvaluateDialog.ShowHistory"){

            public void actionPerformed(AnActionEvent e) {
                ExpressionInputComponent.this.showHistory();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(LookupManager.getActiveLookup(ExpressionInputComponent.this.myExpressionEditor.getEditor()) == null);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DOWN"}), (JComponent)this.myMainForm.getMainPanel(), parentDisposable);
    }

    private void showHistory() {
        List<XExpression> expressions2 = this.myExpressionEditor.getRecentExpressions();
        if (!expressions2.isEmpty()) {
            ListPopupImpl popup2 = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<XExpression>(null, expressions2){

                public PopupStep onChosen(XExpression selectedValue, boolean finalChoice) {
                    ExpressionInputComponent.this.myExpressionEditor.setExpression(selectedValue);
                    ExpressionInputComponent.this.myExpressionEditor.requestFocusInEditor();
                    return FINAL_CHOICE;
                }
            }){

                @Override
                protected ListCellRenderer getListElementRenderer() {
                    return new ColoredListCellRenderer<XExpression>(){

                        protected void customizeCellRenderer(@NotNull JList list2, XExpression value2, int index, boolean selected, boolean hasFocus) {
                            if (list2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            this.append(value2.getExpression());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent$5$1", "customizeCellRenderer"));
                        }
                    };
                }
            };
            popup2.getList().setFont(EditorUtil.getEditorFont());
            popup2.showUnderneathOf(this.myExpressionEditor.getEditorComponent());
        }
    }

    @Override
    public void addComponent(JPanel contentPanel, JPanel resultPanel) {
        contentPanel.add((Component)resultPanel, "Center");
        contentPanel.add((Component)this.myMainForm.getMainPanel(), "North");
    }

    @Override
    public JPanel getMainComponent() {
        return this.myMainForm.getMainPanel();
    }

    @Override
    @NotNull
    public XDebuggerEditorBase getInputEditor() {
        XDebuggerExpressionEditor xDebuggerExpressionEditor = this.myExpressionEditor;
        if (xDebuggerExpressionEditor == null) {
            ExpressionInputComponent.$$$reportNull$$$0(3);
        }
        return xDebuggerExpressionEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

