/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextViewer
extends EditorTextField {
    private final boolean myEmbeddedIntoDialogWrapper;

    public TextViewer(@NotNull String initialText, @NotNull Project project2, boolean viewer) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            TextViewer.$$$reportNull$$$0(1);
        }
        this(TextViewer.createDocument(initialText, viewer), project2, true, viewer);
    }

    public TextViewer(@NotNull String initialText, @NotNull Project project2) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            TextViewer.$$$reportNull$$$0(3);
        }
        this(initialText, project2, true);
    }

    public TextViewer(@NotNull Document document, @NotNull Project project2, boolean embeddedIntoDialogWrapper, boolean viewer) {
        if (document == null) {
            TextViewer.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            TextViewer.$$$reportNull$$$0(5);
        }
        super(document, project2, (FileType)FileTypes.PLAIN_TEXT, viewer, false);
        this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
        this.setFontInheritedFromLAF(false);
    }

    private static Document createDocument(@NotNull String initialText, boolean viewer) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(6);
        }
        if (TextViewer.needSlashRSupport(initialText, viewer)) {
            return ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(initialText, true, false);
        }
        return EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)initialText));
    }

    @Override
    public void setText(@Nullable String text2) {
        if (text2 != null) {
            if (TextViewer.needSlashRSupport(text2, this.isViewer())) {
                Editor editor;
                if (!((DocumentImpl)this.getDocument()).setAcceptSlashR(true) && (editor = this.getEditor()) instanceof EditorEx) {
                    ((EditorEx)editor).reinitSettings();
                }
            } else {
                text2 = StringUtil.convertLineSeparators((String)text2);
            }
        }
        super.setText(text2);
    }

    private static boolean needSlashRSupport(String text2, boolean viewer) {
        return !viewer && text2.contains("\r");
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setHorizontalScrollbarVisible(true);
        editor.setCaretEnabled(true);
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
        editor.getComponent().setPreferredSize(null);
        editor.getSettings().setUseSoftWraps(true);
        editor.setColorsScheme(DebuggerUIUtil.getColorScheme());
        return editor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/TextViewer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createDocument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

