/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dtd;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeDescriptorImpl
extends BasicXmlAttributeDescriptor
implements PsiWritableMetaData {
    private XmlAttributeDecl myDecl;
    private boolean myRequired;
    private boolean myEnumerated;
    private boolean myFixed;
    private String myName;

    public XmlAttributeDescriptorImpl() {
    }

    public XmlAttributeDescriptorImpl(XmlAttributeDecl decl) {
        this.init((PsiElement)decl);
    }

    public boolean isRequired() {
        return this.myRequired;
    }

    public PsiElement getDeclaration() {
        return this.myDecl;
    }

    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        this.myName = this.myDecl.getNameElement().getText();
        return this.myName;
    }

    public void init(PsiElement element) {
        this.myDecl = (XmlAttributeDecl)element;
        this.myRequired = this.myDecl.isAttributeRequired();
        this.myFixed = this.myDecl.isAttributeFixed();
        this.myEnumerated = this.myDecl.isEnumerated();
    }

    @NotNull
    public Object[] getDependences() {
        Object[] objectArray = new Object[]{this.myDecl};
        if (objectArray == null) {
            XmlAttributeDescriptorImpl.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    public boolean isFixed() {
        return this.myFixed;
    }

    public boolean hasIdType() {
        return this.myDecl.isIdAttribute();
    }

    public boolean hasIdRefType() {
        return this.myDecl.isIdRefAttribute();
    }

    @Override
    public String getDefaultValue() {
        String text2 = this.myDecl.getDefaultValueText();
        if (text2 != null) {
            return text2.substring(1, text2.length() - 1);
        }
        return null;
    }

    public boolean isEnumerated() {
        return this.myEnumerated;
    }

    @Override
    public String[] getEnumeratedValues() {
        XmlElement[] values = this.myDecl.getEnumeratedValues();
        ArrayList<String> result2 = new ArrayList<String>();
        for (XmlElement value2 : values) {
            result2.add(value2.getText());
        }
        return ArrayUtil.toStringArray(result2);
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public void setName(String name2) throws IncorrectOperationException {
        this.myName = name2;
        ((PsiNamedElement)this.getDeclaration()).setName(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/dtd/XmlAttributeDescriptorImpl", "getDependences"));
    }
}

