/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonPropertyAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonOriginalPsiWalker
implements JsonLikePsiWalker {
    public static final JsonOriginalPsiWalker INSTANCE = new JsonOriginalPsiWalker();

    public boolean handles(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(0);
        }
        return element instanceof JsonElement || element instanceof LeafPsiElement && element.getParent() instanceof JsonElement;
    }

    @Override
    public boolean isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof JsonObject) {
            return true;
        }
        if (parent instanceof JsonProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JsonProperty)parent).getNameElement(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    @Override
    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(1);
        }
        return element instanceof JsonProperty && ((JsonProperty)element).getValue() != null;
    }

    @Override
    public PsiElement goUpToCheckable(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(2);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof JsonValue) && !(current instanceof JsonProperty)) continue;
            return current;
        }
        return null;
    }

    @Override
    public List<JsonSchemaVariantsTreeBuilder.Step> findPosition(@NotNull PsiElement element, boolean isName, boolean forceLastTransition) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(3);
        }
        ArrayList<JsonSchemaVariantsTreeBuilder.Step> steps = new ArrayList<JsonSchemaVariantsTreeBuilder.Step>();
        PsiElement current = element;
        while (!(current instanceof PsiFile)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JsonArray) {
                JsonArray array = (JsonArray)current;
                List<JsonValue> list2 = array.getValueList();
                int idx = -1;
                for (int i = 0; i < list2.size(); ++i) {
                    JsonValue value2 = list2.get(i);
                    if (!value2.equals(position)) continue;
                    idx = i;
                    break;
                }
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createArrayElementStep(idx));
                continue;
            }
            if (current instanceof JsonProperty) {
                propertyName = ((JsonProperty)current).getName();
                if (!((current = current.getParent()) instanceof JsonObject)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createPropertyStep(propertyName));
                continue;
            }
            if (current instanceof JsonObject && position instanceof JsonProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = ((JsonProperty)position).getName();
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createPropertyStep(propertyName));
                continue;
            }
            if (current instanceof PsiFile) break;
            return null;
        }
        Collections.reverse(steps);
        return steps;
    }

    @Override
    public boolean isNameQuoted() {
        return true;
    }

    @Override
    public boolean onlyDoubleQuotesForStringLiterals() {
        return true;
    }

    @Override
    public boolean hasPropertiesBehindAndNoComma(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = current = element instanceof JsonProperty ? element : PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
        while (current != null && current.getNode().getElementType() != JsonElementTypes.COMMA) {
            current = current.getNextSibling();
        }
        int commaOffset = current == null ? Integer.MAX_VALUE : current.getTextRange().getStartOffset();
        int offset = element.getTextRange().getStartOffset();
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class);
        if (object != null) {
            for (JsonProperty property : object.getPropertyList()) {
                int pOffset = property.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    @Override
    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement element) {
        JsonObject object;
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(5);
        }
        if ((object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class)) != null) {
            return object.getPropertyList().stream().filter(p -> p.getNameElement() instanceof JsonStringLiteral).map(p -> StringUtil.unquoteString((String)p.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        JsonProperty property;
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(6);
        }
        if ((property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false)) == null) {
            return null;
        }
        return new JsonJsonPropertyAdapter(property);
    }

    @Override
    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(7);
        }
        return element instanceof PsiFile;
    }

    @Override
    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            JsonOriginalPsiWalker.$$$reportNull$$$0(8);
        }
        return element instanceof JsonValue ? JsonJsonPropertyAdapter.createAdapterByType((JsonValue)element) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonOriginalPsiWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyWithValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "goUpToCheckable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPropertiesBehindAndNoComma";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentPropertyAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopJsonElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createValueAdapter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

