/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaResolver {
    @NotNull
    private final JsonSchemaObject mySchema;
    private final boolean myIsName;
    @NotNull
    private final List<JsonSchemaVariantsTreeBuilder.Step> myPosition;

    public JsonSchemaResolver(@NotNull JsonSchemaObject schema, boolean isName, @NotNull List<JsonSchemaVariantsTreeBuilder.Step> position) {
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(0);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(1);
        }
        this.mySchema = schema;
        this.myIsName = isName;
        this.myPosition = position;
    }

    public JsonSchemaResolver(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(2);
        }
        this.mySchema = schema;
        this.myIsName = true;
        this.myPosition = Collections.emptyList();
    }

    public MatchResult detailedResolve() {
        return this.detailedResolve(false, false, false);
    }

    private MatchResult detailedResolve(boolean skipLastExpand, boolean literalResolve, boolean acceptAdditionalPropertiesSchema) {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.mySchema, this.myPosition, skipLastExpand, literalResolve, acceptAdditionalPropertiesSchema || !this.myIsName);
        return MatchResult.create(node);
    }

    @NotNull
    public Collection<JsonSchemaObject> resolve() {
        Collection<JsonSchemaObject> collection = this.resolve(false, false, false);
        if (collection == null) {
            JsonSchemaResolver.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private Collection<JsonSchemaObject> resolve(boolean skipLastExpand, boolean literalResolve, boolean acceptAdditionalPropertiesSchema) {
        MatchResult result2 = this.detailedResolve(skipLastExpand, literalResolve, acceptAdditionalPropertiesSchema);
        ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>(result2.mySchemas);
        list2.addAll(result2.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        return list2;
    }

    @Nullable
    public PsiElement findNavigationTarget(boolean literalResolve, boolean acceptAdditionalPropertiesSchema) {
        Collection<JsonSchemaObject> schemas = this.resolve(true, literalResolve, acceptAdditionalPropertiesSchema);
        return schemas.stream().filter(schema -> schema.getJsonObject().isValid()).findFirst().map(schema -> {
            JsonObject jsonObject = schema.getJsonObject();
            if (jsonObject.getParent() instanceof JsonProperty) {
                return ((JsonProperty)jsonObject.getParent()).getNameElement();
            }
            return jsonObject;
        }).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

