/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ComparableImplementedButEqualsNotOverriddenInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.display.name", new Object[0]);
        if (string == null) {
            ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.problem.descriptor", new Object[0]);
        if (string == null) {
            ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareToAndEqualsNotPairedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CompareToAndEqualsNotPairedVisitor
    extends BaseInspectionVisitor {
        private CompareToAndEqualsNotPairedVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            PsiMethod[] equalsMethods;
            GlobalSearchScope scope;
            super.visitClass(aClass);
            if (aClass.isInterface()) {
                return;
            }
            PsiMethod[] methods = aClass.findMethodsByName("compareTo", false);
            if (methods.length == 0) {
                return;
            }
            Project project2 = aClass.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass comparableClass = psiFacade.findClass("java.lang.Comparable", scope = aClass.getResolveScope());
            if (comparableClass == null) {
                return;
            }
            if (!aClass.isInheritor(comparableClass, true)) {
                return;
            }
            PsiMethod compareToMethod = comparableClass.getMethods()[0];
            boolean foundCompareTo = false;
            for (PsiMethod method : methods) {
                if (!MethodSignatureUtil.isSuperMethod((PsiMethod)compareToMethod, (PsiMethod)method)) continue;
                foundCompareTo = true;
                break;
            }
            if (!foundCompareTo) {
                return;
            }
            for (PsiMethod equalsMethod : equalsMethods = aClass.findMethodsByName("equals", false)) {
                if (!MethodUtils.isEquals(equalsMethod)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

