/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class NegatedEqualityExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.equality.expression.display.name", new Object[0]);
        if (string == null) {
            NegatedEqualityExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.equality.expression.problem.descriptor", infos[0]);
        if (string == null) {
            NegatedEqualityExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedEqualityExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NegatedEqualsVisitor
    extends BaseInspectionVisitor {
        private NegatedEqualsVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (!JavaTokenType.EXCL.equals(expression2.getOperationTokenType())) {
                return;
            }
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(expression2.getOperand());
            if (!(operand2 instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                this.registerError((PsiElement)expression2.getOperationSign(), "==");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                this.registerError((PsiElement)expression2.getOperationSign(), "!=");
            }
        }
    }

    private static class NegatedEqualityExpressionFix
    extends InspectionGadgetsFix {
        private NegatedEqualityExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.equality.expression.quickfix", new Object[0]);
            if (string == null) {
                NegatedEqualityExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            if (!(operand2 instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            StringBuilder text2 = new StringBuilder(binaryExpression.getLOperand().getText());
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                text2.append("!=");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                text2.append("==");
            } else {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs != null) {
                text2.append(rhs.getText());
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, text2.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedEqualityExpressionInspection$NegatedEqualityExpressionFix", "getFamilyName"));
        }
    }
}

