/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessNullCheckInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.display.name", new Object[0]);
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression parent = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[1]), (Class[])new Class[]{PsiInstanceOfExpression.class, PsiMethodCallExpression.class});
        if (parent instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.call", ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceName());
            if (string == null) {
                PointlessNullCheckInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.instanceof", new Object[0]);
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessNullCheckVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        return new PointlessNullCheckFix(expression2.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/PointlessNullCheckInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PointlessNullCheckVisitor
    extends BaseInspectionVisitor {
        private PointlessNullCheckVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType operationTokenType = expression2.getOperationTokenType();
            if (operationTokenType.equals(JavaTokenType.ANDAND)) {
                this.checkAndChain(expression2);
            } else if (operationTokenType.equals(JavaTokenType.OROR)) {
                this.checkOrChain(expression2);
            }
        }

        private void checkOrChain(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 0; i < operands2.length - 1; ++i) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[i]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.EQEQ)) continue;
                for (int j = i + 1; j < operands2.length; ++j) {
                    PsiExpression implicitCheckCandidate = BoolUtils.getNegated(PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[j]));
                    if (!this.checkExpressions(operands2, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private void checkAndChain(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 0; i < operands2.length - 1; ++i) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[i]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.NE)) continue;
                for (int j = i + 1; j < operands2.length; ++j) {
                    PsiExpression implicitCheckCandidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands2[j]);
                    if (!this.checkExpressions(operands2, i, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private boolean checkExpressions(PsiExpression[] operands2, int i, int j, PsiBinaryExpression binaryExpression, PsiExpression implicitCheckCandidate) {
            PsiReferenceExpression explicitCheckReference = PointlessNullCheckVisitor.getReferenceFromNullCheck(binaryExpression);
            if (explicitCheckReference == null) {
                return false;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)explicitCheckReference.resolve(), PsiVariable.class);
            PsiReferenceExpression implicitCheckReference = PointlessNullCheckVisitor.getReferenceFromImplicitNullCheckExpression(implicitCheckCandidate);
            if (implicitCheckReference == null || !implicitCheckReference.isReferenceTo((PsiElement)variable)) {
                return false;
            }
            if (PointlessNullCheckVisitor.isVariableUsed(operands2, i, j, variable)) {
                return false;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression, implicitCheckReference);
            return true;
        }

        private static boolean isVariableUsed(PsiExpression[] operands2, int i, int j, PsiVariable variable) {
            return Arrays.stream(operands2, i + 1, j).anyMatch(op -> VariableAccessUtils.variableIsUsed(variable, (PsiElement)op));
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromNullCheck(PsiBinaryExpression expression2) {
            PsiExpression comparedWithNull = ExpressionUtils.getValueComparedWithNull(expression2);
            return (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedWithNull), PsiReferenceExpression.class);
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromImplicitNullCheckExpression(PsiExpression expression2) {
            PsiReferenceExpression checked = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2));
            if (checked == null) {
                checked = PointlessNullCheckVisitor.getReferenceFromBooleanCall(expression2);
            }
            if (checked == null) {
                checked = PointlessNullCheckVisitor.getReferenceFromOrChain(expression2);
            }
            return checked;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromInstanceofExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiInstanceOfExpression)) {
                return null;
            }
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiInstanceOfExpression)expression2).getOperand());
            return (PsiReferenceExpression)ObjectUtils.tryCast((Object)operand2, PsiReferenceExpression.class);
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromBooleanCall(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (!PsiType.BOOLEAN.equals((Object)call.getType())) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            List<? extends MethodContract> contracts2 = ControlFlowAnalyzer.getMethodCallContracts(method, call);
            if (contracts2.isEmpty()) {
                return null;
            }
            StandardMethodContract contract = (StandardMethodContract)ObjectUtils.tryCast((Object)contracts2.get(0), StandardMethodContract.class);
            if (contract == null || contract.getReturnValue() != MethodContract.ValueConstraint.FALSE_VALUE) {
                return null;
            }
            MethodContract.ValueConstraint[] arguments = contract.arguments;
            int idx = -1;
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] == MethodContract.ValueConstraint.NULL_VALUE) {
                    if (idx != -1) {
                        return null;
                    }
                    idx = i;
                    continue;
                }
                if (arguments[i] == MethodContract.ValueConstraint.ANY_VALUE) continue;
                return null;
            }
            if (idx == -1) {
                return null;
            }
            PsiExpression[] args = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions();
            if (args.length <= idx || method.isVarArgs() && idx == args.length - 1) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)args[idx], PsiReferenceExpression.class);
            if (reference == null) {
                return null;
            }
            PsiVariable target2 = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
            if (target2 == null) {
                return null;
            }
            if (!SyntaxTraverser.psiTraverser((PsiElement)call).filter(PsiReference.class).filter(ref -> !reference.equals(ref) && ref.isReferenceTo((PsiElement)target2)).isEmpty()) {
                return null;
            }
            return reference;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromOrChain(PsiExpression expression2) {
            if (!(expression2 instanceof PsiPolyadicExpression)) {
                return null;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.OROR != tokenType) {
                return null;
            }
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            PsiReferenceExpression referenceExpression = PointlessNullCheckVisitor.getReferenceFromImplicitNullCheckExpression(operands2[0]);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            int operandsLength = operands2.length;
            for (int i = 1; i < operandsLength; ++i) {
                PsiReferenceExpression reference2 = PointlessNullCheckVisitor.getReferenceFromImplicitNullCheckExpression(operands2[i]);
                if (reference2 != null && reference2.isReferenceTo((PsiElement)variable)) continue;
                return null;
            }
            return referenceExpression;
        }
    }

    private static class PointlessNullCheckFix
    extends InspectionGadgetsFix {
        private final String myExpressionText;

        public PointlessNullCheckFix(String expressionText) {
            this.myExpressionText = expressionText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.simplify.quickfix", this.myExpressionText);
            if (string == null) {
                PointlessNullCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                PointlessNullCheckFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class);
            if (polyadicExpression == null) {
                return;
            }
            Object[] children2 = polyadicExpression.getChildren();
            int start = IntStreamEx.ofIndices((Object[])children2, child -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)element, (boolean)false)).findFirst().orElse(-1);
            if (start == -1) {
                return;
            }
            int end = IntStreamEx.range((int)(start + 1), (int)children2.length).findFirst(arg_0 -> PointlessNullCheckFix.lambda$doFix$1((PsiElement[])children2, arg_0)).orElse(-1);
            if (end == -1) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = IntStreamEx.range((int)0, (int)start).append((IntStream)IntStreamEx.range((int)end, (int)children2.length)).elements(children2).map(ct::text).joining();
            ct.replaceAndRestoreComments((PsiElement)polyadicExpression, replacement);
        }

        private static /* synthetic */ boolean lambda$doFix$1(PsiElement[] children2, int idx) {
            return children2[idx] instanceof PsiExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

