/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.dataflow.ScopeUtils;
import com.siyeh.ig.dataflow.TooBroadScopeInspectionBase;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooBroadScopeInspection
extends TooBroadScopeInspectionBase {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        return new TooBroadScopeInspectionFix(variable.getName());
    }

    private class TooBroadScopeInspectionFix
    extends InspectionGadgetsFix {
        private final String variableName;

        TooBroadScopeInspectionFix(String variableName) {
            this.variableName = variableName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("too.broad.scope.narrow.quickfix", this.variableName);
            if (string == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Narrow scope" == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(1);
            }
            return "Narrow scope";
        }

        @Override
        protected void doFix(@NotNull Project project2, ProblemDescriptor descriptor2) {
            PsiDeclarationStatement newDeclaration;
            PsiElement firstReferenceScope;
            PsiElement referenceElement;
            PsiElement variableIdentifier;
            if (project2 == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(2);
            }
            if (!((variableIdentifier = descriptor2.getPsiElement()) instanceof PsiIdentifier)) {
                return;
            }
            PsiVariable variable = (PsiVariable)variableIdentifier.getParent();
            assert (variable != null);
            Query query = ReferencesSearch.search((PsiElement)variable);
            Collection referenceCollection = query.findAll();
            PsiElement[] referenceElements = new PsiElement[referenceCollection.size()];
            int index = 0;
            for (PsiReference reference : referenceCollection) {
                referenceElements[index] = referenceElement = reference.getElement();
                ++index;
            }
            PsiElement commonParent = ScopeUtils.getCommonParent(referenceElements);
            assert (commonParent != null);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                PsiElement variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
                assert (variableScope != null);
                if ((commonParent = ScopeUtils.moveOutOfLoopsAndClasses(commonParent, variableScope)) == null) {
                    return;
                }
            }
            if ((firstReferenceScope = PsiTreeUtil.getParentOfType((PsiElement)(referenceElement = referenceElements[0]), (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class})) == null) {
                return;
            }
            if (commonParent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)commonParent;
                PsiStatement initialization = forStatement.getInitialization();
                if (initialization == null) {
                    return;
                }
                if (initialization instanceof PsiExpressionStatement) {
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)initialization;
                    PsiExpression expression2 = expressionStatement.getExpression();
                    if (!(expression2 instanceof PsiAssignmentExpression)) {
                        return;
                    }
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                    PsiExpression rhs = assignmentExpression.getRExpression();
                    newDeclaration = this.createNewDeclaration(variable, rhs);
                } else {
                    newDeclaration = this.createNewDeclaration(variable, initializer);
                }
                newDeclaration = (PsiDeclarationStatement)initialization.replace((PsiElement)newDeclaration);
            } else if (firstReferenceScope.equals(commonParent)) {
                newDeclaration = this.moveDeclarationToLocation(variable, referenceElement);
            } else {
                PsiElement commonParentChild = ScopeUtils.getChildWhichContainsElement(commonParent, referenceElement);
                if (commonParentChild == null) {
                    return;
                }
                PsiElement location = commonParentChild.getPrevSibling();
                newDeclaration = this.createNewDeclaration(variable, initializer);
                newDeclaration = (PsiDeclarationStatement)commonParent.addAfter((PsiElement)newDeclaration, location);
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
            newDeclaration = (PsiDeclarationStatement)codeStyleManager.reformat((PsiElement)newDeclaration);
            this.removeOldVariable(variable);
            if (this.isOnTheFly()) {
                HighlightUtils.highlightElement((PsiElement)newDeclaration);
            }
        }

        private void removeOldVariable(@NotNull PsiVariable variable) {
            PsiDeclarationStatement declaration2;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(3);
            }
            if ((declaration2 = (PsiDeclarationStatement)variable.getParent()) == null) {
                return;
            }
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length == 1) {
                declaration2.delete();
            } else {
                variable.delete();
            }
        }

        private PsiDeclarationStatement createNewDeclaration(@NotNull PsiVariable variable, @Nullable PsiExpression initializer) {
            String statementText;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(4);
            }
            Project project2 = variable.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = psiFacade.getElementFactory();
            String name2 = variable.getName();
            if (name2 == null) {
                name2 = "";
            }
            String comment = initializer == null || initializer.getParent() == variable ? this.getCommentText((PsiElement)variable) : this.getCommentText((PsiElement)variable) + this.getCommentText((PsiElement)initializer);
            PsiType type2 = variable.getType();
            String typeText = type2.getCanonicalText();
            if (initializer == null) {
                statementText = typeText + ' ' + name2 + ';' + comment;
            } else {
                String initializerText = initializer.getText();
                statementText = typeText + ' ' + name2 + '=' + initializerText + ';' + comment;
            }
            PsiDeclarationStatement newDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(statementText, (PsiElement)variable);
            PsiLocalVariable newVariable = (PsiLocalVariable)newDeclaration.getDeclaredElements()[0];
            PsiModifierList newModifierList = newVariable.getModifierList();
            PsiModifierList modifierList = variable.getModifierList();
            if (newModifierList != null && modifierList != null) {
                newModifierList.setModifierProperty("final", variable.hasModifierProperty("final"));
                GenerateMembersUtil.copyAnnotations(modifierList, newModifierList, new String[0]);
            }
            return newDeclaration;
        }

        private String getCommentText(PsiElement element) {
            PsiDeclarationStatement parentDeclaration;
            PsiElement[] declaredElements;
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
            if (parent == null) {
                return "";
            }
            if (parent instanceof PsiDeclarationStatement && (declaredElements = (parentDeclaration = (PsiDeclarationStatement)parent).getDeclaredElements()).length != 1) {
                return "";
            }
            PsiElement lastChild = parent.getLastChild();
            if (!(lastChild instanceof PsiComment)) {
                return "";
            }
            PsiElement prevSibling = lastChild.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                return prevSibling.getText() + lastChild.getText();
            }
            return lastChild.getText();
        }

        private PsiDeclarationStatement moveDeclarationToLocation(@NotNull PsiVariable variable, @NotNull PsiElement location) {
            PsiExpressionStatement expressionStatement;
            PsiExpression expression2;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(5);
            }
            if (location == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(6);
            }
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)location, PsiStatement.class, (boolean)false);
            assert (statement2 != null);
            PsiElement statementParent = statement2.getParent();
            while (statementParent instanceof PsiStatement && !(statementParent instanceof PsiForStatement)) {
                statement2 = (PsiStatement)statementParent;
                statementParent = statement2.getParent();
            }
            assert (statementParent != null);
            PsiExpression initializer = variable.getInitializer();
            if (TooBroadScopeInspection.this.isMoveable(initializer) && statement2 instanceof PsiExpressionStatement && (expression2 = (expressionStatement = (PsiExpressionStatement)statement2).getExpression()) instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                PsiExpression rhs = assignmentExpression.getRExpression();
                PsiExpression lhs = assignmentExpression.getLExpression();
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (location.equals(lhs) && JavaTokenType.EQ == tokenType && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                    PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, rhs);
                    newDeclaration = (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement2);
                    PsiElement parent = assignmentExpression.getParent();
                    assert (parent != null);
                    parent.delete();
                    return newDeclaration;
                }
            }
            PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, initializer);
            if (statement2 instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)statement2;
                PsiStatement initialization = forStatement.getInitialization();
                newDeclaration = (PsiDeclarationStatement)forStatement.addBefore((PsiElement)newDeclaration, (PsiElement)initialization);
                if (initialization != null) {
                    initialization.delete();
                }
                return newDeclaration;
            }
            return (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeOldVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewDeclaration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "moveDeclarationToLocation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

