/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExceptionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowCaughtLocallyInspection
extends BaseInspection {
    public boolean ignoreRethrownExceptions = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("throw.caught.locally.display.name", new Object[0]);
        if (string == null) {
            ThrowCaughtLocallyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("throw.caught.locally.problem.descriptor", new Object[0]);
        if (string == null) {
            ThrowCaughtLocallyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("throw.caught.locally.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreRethrownExceptions");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowCaughtLocallyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ThrowCaughtLocallyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ThrowCaughtLocallyVisitor
    extends BaseInspectionVisitor {
        private ThrowCaughtLocallyVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression exception = statement2.getException();
            if (exception == null) {
                return;
            }
            PsiType exceptionType = exception.getType();
            if (exceptionType == null) {
                return;
            }
            PsiTryStatement containingTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
            while (containingTryStatement != null) {
                PsiCodeBlock tryBlock = containingTryStatement.getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)statement2, (boolean)true)) {
                    PsiParameter[] catchBlockParameters;
                    for (PsiParameter parameter2 : catchBlockParameters = containingTryStatement.getCatchBlockParameters()) {
                        PsiCatchSection section;
                        PsiCodeBlock catchBlock;
                        PsiType parameterType = parameter2.getType();
                        if (!parameterType.isAssignableFrom(exceptionType)) continue;
                        if (ThrowCaughtLocallyInspection.this.ignoreRethrownExceptions && ExceptionUtils.isThrowableRethrown(parameter2, catchBlock = (section = (PsiCatchSection)parameter2.getParent()).getCatchBlock())) {
                            return;
                        }
                        this.registerStatementError((PsiStatement)statement2, new Object[0]);
                    }
                }
                containingTryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)containingTryStatement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
            }
        }
    }
}

