/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TooBroadCatchInspectionBase
extends BaseInspection {
    public boolean onlyWarnOnRootExceptions = false;
    public boolean ignoreInTestCode = false;
    public boolean ignoreThrown = false;

    @NotNull
    public String getID() {
        if ("OverlyBroadCatchBlock" == null) {
            TooBroadCatchInspectionBase.$$$reportNull$$$0(0);
        }
        return "OverlyBroadCatchBlock";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.catch.display.name", new Object[0]);
        if (string == null) {
            TooBroadCatchInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        List typesMasked = (List)infos[0];
        String typesMaskedString = ((PsiType)typesMasked.get(0)).getPresentableText();
        if (typesMasked.size() == 1) {
            String string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor", typesMaskedString);
            if (string == null) {
                TooBroadCatchInspectionBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        int lastTypeIndex = typesMasked.size() - 1;
        for (int i = 1; i < lastTypeIndex; ++i) {
            typesMaskedString = typesMaskedString + ", ";
            typesMaskedString = typesMaskedString + ((PsiType)typesMasked.get(i)).getPresentableText();
        }
        String lastTypeString = ((PsiType)typesMasked.get(lastTypeIndex)).getPresentableText();
        String string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor1", typesMaskedString, lastTypeString);
        if (string == null) {
            TooBroadCatchInspectionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadCatchVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/TooBroadCatchInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TooBroadCatchVisitor
    extends BaseInspectionVisitor {
        private TooBroadCatchVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            if (statement2 == null) {
                TooBroadCatchVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement2);
            PsiCodeBlock tryBlock = statement2.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Set<PsiClassType> thrownTypes = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
            ExceptionUtils.calculateExceptionsThrown((PsiElement)statement2.getResourceList(), thrownTypes);
            HashSet<PsiType> caughtTypes = new HashSet<PsiType>(thrownTypes.size());
            PsiCatchSection[] catchSections = statement2.getCatchSections();
            boolean runtimeExceptionSeen = false;
            for (PsiCatchSection catchSection : catchSections) {
                PsiTypeElement typeElement;
                PsiParameter parameter2 = catchSection.getParameter();
                if (parameter2 == null || (typeElement = parameter2.getTypeElement()) == null) continue;
                PsiTypeElement[] children2 = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
                if (children2 != null) {
                    for (PsiTypeElement child : children2) {
                        runtimeExceptionSeen = this.check(thrownTypes, child, runtimeExceptionSeen, caughtTypes);
                    }
                    continue;
                }
                runtimeExceptionSeen = this.check(thrownTypes, typeElement, runtimeExceptionSeen, caughtTypes);
            }
        }

        private boolean check(Set<PsiClassType> thrownTypes, PsiTypeElement caughtTypeElement, boolean runtimeExceptionSeen, Set<PsiType> caughtTypes) {
            PsiType caughtType = caughtTypeElement.getType();
            if ("java.lang.RuntimeException".equals(caughtType.getCanonicalText())) {
                runtimeExceptionSeen = true;
            } else if (thrownTypes.isEmpty() && "java.lang.Exception".equals(caughtType.getCanonicalText()) && !runtimeExceptionSeen) {
                PsiClassType runtimeExceptionType = TypeUtils.getType("java.lang.RuntimeException", (PsiElement)caughtTypeElement);
                this.registerError((PsiElement)caughtTypeElement, Collections.singletonList(runtimeExceptionType), caughtTypeElement);
            }
            List<PsiType> maskedExceptions = this.findMaskedExceptions(thrownTypes, caughtType, caughtTypes);
            if (maskedExceptions.isEmpty()) {
                return runtimeExceptionSeen;
            }
            this.registerError((PsiElement)caughtTypeElement, maskedExceptions, caughtTypeElement);
            return runtimeExceptionSeen;
        }

        private List<PsiType> findMaskedExceptions(Set<PsiClassType> thrownTypes, PsiType caughtType, Set<PsiType> caughtTypes) {
            if (thrownTypes.contains(caughtType)) {
                if (TooBroadCatchInspectionBase.this.ignoreThrown) {
                    return Collections.emptyList();
                }
                caughtTypes.add(caughtType);
                thrownTypes.remove(caughtType);
            }
            if (TooBroadCatchInspectionBase.this.onlyWarnOnRootExceptions && !ExceptionUtils.isGenericExceptionClass(caughtType)) {
                return Collections.emptyList();
            }
            ArrayList<PsiType> maskedTypes = new ArrayList<PsiType>();
            for (PsiType psiType : thrownTypes) {
                if (caughtTypes.contains(psiType) || !caughtType.isAssignableFrom(psiType)) continue;
                caughtTypes.add(psiType);
                maskedTypes.add(psiType);
            }
            return maskedTypes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/TooBroadCatchInspectionBase$TooBroadCatchVisitor", "visitTryStatement"));
        }
    }
}

