/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeClassFinalFix
extends InspectionGadgetsFix {
    private final String className;

    public MakeClassFinalFix(PsiClass aClass) {
        this.className = aClass.getName();
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.class.final.fix.name", this.className);
        if (string == null) {
            MakeClassFinalFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Make class final" == null) {
            MakeClassFinalFix.$$$reportNull$$$0(1);
        }
        return "Make class final";
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        boolean conflictsDialogOK;
        PsiElement element = descriptor2.getPsiElement();
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (containingClass == null) {
            return;
        }
        PsiModifierList modifierList = containingClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!this.isOnTheFly()) {
            if (ClassInheritorsSearch.search((PsiClass)containingClass).findFirst() != null) {
                return;
            }
            MakeClassFinalFix.doMakeFinal(modifierList);
            return;
        }
        MultiMap conflicts = new MultiMap();
        Query search2 = ClassInheritorsSearch.search((PsiClass)containingClass);
        search2.forEach(aClass -> {
            conflicts.putValue((Object)containingClass, (Object)InspectionGadgetsBundle.message("0.will.no.longer.be.overridable.by.1", RefactoringUIUtil.getDescription((PsiElement)containingClass, false), RefactoringUIUtil.getDescription((PsiElement)aClass, false)));
            return true;
        });
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(element.getProject(), (MultiMap<PsiElement, String>)conflicts, () -> MakeClassFinalFix.doMakeFinal(modifierList));
            conflictsDialogOK = conflictsDialog.showAndGet();
        } else {
            conflictsDialogOK = true;
        }
        if (conflictsDialogOK) {
            MakeClassFinalFix.doMakeFinal(modifierList);
        }
    }

    private static void doMakeFinal(PsiModifierList modifierList) {
        WriteAction.run(() -> {
            modifierList.setModifierProperty("final", true);
            modifierList.setModifierProperty("abstract", false);
        });
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            MakeClassFinalFix.$$$reportNull$$$0(2);
        }
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/MakeClassFinalFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/MakeClassFinalFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

