/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

class StaticInheritanceFix
extends InspectionGadgetsFix {
    private final boolean myReplaceInWholeProject;

    StaticInheritanceFix(boolean replaceInWholeProject) {
        this.myReplaceInWholeProject = replaceInWholeProject;
    }

    @NotNull
    public String getName() {
        String scope = this.myReplaceInWholeProject ? InspectionGadgetsBundle.message("the.whole.project", new Object[0]) : InspectionGadgetsBundle.message("this.class", new Object[0]);
        String string = InspectionGadgetsBundle.message("static.inheritance.replace.quickfix", scope);
        if (string == null) {
            StaticInheritanceFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace inheritance with qualified reference" == null) {
            StaticInheritanceFix.$$$reportNull$$$0(1);
        }
        return "Replace inheritance with qualified reference";
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void doFix(final Project project2, ProblemDescriptor descriptor2) {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)descriptor2.getPsiElement();
        final PsiClass iface = (PsiClass)referenceElement.resolve();
        assert (iface != null);
        final PsiField[] allFields = iface.getAllFields();
        final PsiClass implementingClass = ClassUtils.getContainingClass((PsiElement)referenceElement);
        assert (implementingClass != null);
        final PsiFile file2 = implementingClass.getContainingFile();
        ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Replacing usages of " + iface.getName(), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiField field : allFields) {
                    SearchScope scope = (SearchScope)ReadAction.compute(() -> implementingClass.getUseScope());
                    Query search2 = ReferencesSearch.search((PsiElement)field, (SearchScope)scope, (boolean)false);
                    for (PsiReference reference : search2) {
                        boolean isInheritor;
                        if (!(reference instanceof PsiReferenceExpression)) continue;
                        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference;
                        if (!StaticInheritanceFix.this.myReplaceInWholeProject && !(isInheritor = ((Boolean)ReadAction.compute(() -> {
                            boolean isInheritor1 = false;
                            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
                            while (aClass != null && !(isInheritor1 = InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)implementingClass, (boolean)true))) {
                                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
                            }
                            return isInheritor1;
                        })).booleanValue())) continue;
                        Runnable runnable2 = () -> {
                            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{referenceExpression})) {
                                return;
                            }
                            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                            PsiReferenceExpression qualified = (PsiReferenceExpression)elementFactory.createExpressionFromText("xxx." + referenceExpression.getText(), (PsiElement)referenceExpression);
                            PsiReferenceExpression newReference = (PsiReferenceExpression)referenceExpression.replace((PsiElement)qualified);
                            PsiReferenceExpression qualifier = (PsiReferenceExpression)newReference.getQualifierExpression();
                            assert (qualifier != null) : DebugUtil.psiToString((PsiElement)newReference, false);
                            PsiClass containingClass = field.getContainingClass();
                            qualifier.bindToElement((PsiElement)containingClass);
                        };
                        TransactionGuard.submitTransaction((Disposable)project2, () -> WriteCommandAction.runWriteCommandAction((Project)project2, null, null, (Runnable)runnable2, (PsiFile[])new PsiFile[]{file2}));
                    }
                }
                Runnable runnable3 = () -> {
                    PsiClassType classType = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createType(iface);
                    LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createExtendsListFix(implementingClass, classType, false);
                    fix.invoke(project2, null, file2);
                };
                TransactionGuard.submitTransaction((Disposable)project2, () -> WriteCommandAction.runWriteCommandAction((Project)project2, null, null, (Runnable)runnable3, (PsiFile[])new PsiFile[]{file2}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/siyeh/ig/inheritance/StaticInheritanceFix$1", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/StaticInheritanceFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

