/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ArrayLengthInLoopConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.length.in.loop.condition.display.name", new Object[0]);
        if (string == null) {
            ArrayLengthInLoopConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.length.in.loop.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayLengthInLoopConditionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayLengthInLoopConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ArrayLengthInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private ArrayLengthInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                ArrayLengthInLoopConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            if (statement2 == null) {
                ArrayLengthInLoopConditionVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            if (statement2 == null) {
                ArrayLengthInLoopConditionVisitor.$$$reportNull$$$0(2);
            }
            super.visitDoWhileStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        private void checkForMethodCalls(PsiExpression condition2) {
            JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
                    if (expression2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(expression2);
                    String name2 = expression2.getReferenceName();
                    if (!"length".equals(name2)) {
                        return;
                    }
                    PsiExpression qualifier = expression2.getQualifierExpression();
                    if (qualifier == null) {
                        return;
                    }
                    PsiType type2 = qualifier.getType();
                    if (!(type2 instanceof PsiArrayType)) {
                        return;
                    }
                    PsiElement lengthElement = expression2.getReferenceNameElement();
                    if (lengthElement == null) {
                        return;
                    }
                    this.registerError(lengthElement, new Object[0]);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor$1", "visitReferenceExpression"));
                }
            };
            condition2.accept((PsiElementVisitor)visitor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

