/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase
extends BaseInspection {
    protected static final String IGNORE = "org.junit.Ignore";

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit4.test.method.in.class.extending.junit3.testcase.display.name", new Object[0]);
        if (string == null) {
            JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)infos[1]), (String)IGNORE, (boolean)false)) {
            String string = InspectionGadgetsBundle.message("ignore.test.method.in.class.extending.junit3.testcase.problem.descriptor", new Object[0]);
            if (string == null) {
                JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("junit4.test.method.in.class.extending.junit3.testcase.problem.descriptor", new Object[0]);
        if (string == null) {
            JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Junit4AnnotatedMethodInJunit3TestCaseVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Junit4AnnotatedMethodInJunit3TestCaseVisitor
    extends BaseInspectionVisitor {
        private Junit4AnnotatedMethodInJunit3TestCaseVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!TestUtils.isJUnitTestClass(containingClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"org.junit.runner.RunWith", (boolean)true)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)JUnit4AnnotatedMethodInJUnit3TestCaseInspectionBase.IGNORE, (boolean)false) && method.getName().startsWith("test")) {
                this.registerMethodError(method, containingClass, method);
            } else if (TestUtils.isJUnit4TestMethod(method)) {
                this.registerMethodError(method, containingClass, method);
            }
        }
    }
}

