/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.MethodNameSameAsClassNameInspectionBase;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsClassNameInspection
extends MethodNameSameAsClassNameInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Boolean onTheFly = (Boolean)infos[0];
        if (onTheFly.booleanValue()) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RenameFix(), new MethodNameSameAsClassNameFix()};
            if (inspectionGadgetsFixArray == null) {
                MethodNameSameAsClassNameInspection.$$$reportNull$$$0(0);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MethodNameSameAsClassNameFix()};
        if (inspectionGadgetsFixArray == null) {
            MethodNameSameAsClassNameInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNameSameAsClassNameInspection", "buildFixes"));
    }

    private static class MethodNameSameAsClassNameFix
    extends InspectionGadgetsFix {
        private MethodNameSameAsClassNameFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.method.ctr.quickfix", new Object[0]);
            if (string == null) {
                MethodNameSameAsClassNameFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null) {
                return;
            }
            returnTypeElement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNameSameAsClassNameInspection$MethodNameSameAsClassNameFix", "getFamilyName"));
        }
    }
}

