/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class ConvertOctalLiteralsToDecimalsFix
extends InspectionGadgetsFix {
    ConvertOctalLiteralsToDecimalsFix() {
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("convert.octal.literals.to.decimal.literals.quickfix", new Object[0]);
        if (string == null) {
            ConvertOctalLiteralsToDecimalsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor2) {
        PsiElement element = descriptor2.getPsiElement();
        if (!(element instanceof PsiArrayInitializerExpression)) {
            return;
        }
        PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)element;
        for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
            PsiLiteralExpression literal;
            if (!((initializer = ParenthesesUtils.stripParentheses(initializer)) instanceof PsiLiteralExpression) || !ExpressionUtils.isOctalLiteral(literal = (PsiLiteralExpression)initializer)) continue;
            ConvertOctalLiteralToDecimalFix.replaceWithDecimalLiteral(literal);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConvertOctalLiteralsToDecimalsFix", "getFamilyName"));
    }
}

