/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomDoubleForRandomIntegerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UsingRandomNextDoubleForRandomInteger" == null) {
            RandomDoubleForRandomIntegerInspection.$$$reportNull$$$0(0);
        }
        return "UsingRandomNextDoubleForRandomInteger";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("random.double.for.random.integer.display.name", new Object[0]);
        if (string == null) {
            RandomDoubleForRandomIntegerInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("random.double.for.random.integer.problem.descriptor", new Object[0]);
        if (string == null) {
            RandomDoubleForRandomIntegerInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RandomDoubleForRandomIntegerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RandomDoubleForRandomIntegerVisitor();
    }

    @Nullable
    static PsiExpression getContainingExpression(PsiExpression expression2) {
        PsiElement ancestor = expression2.getParent();
        while (ancestor != null) {
            if (!(ancestor instanceof PsiExpression)) {
                return null;
            }
            if (!(ancestor instanceof PsiParenthesizedExpression)) {
                return (PsiExpression)ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RandomDoubleForRandomIntegerVisitor
    extends BaseInspectionVisitor {
        private RandomDoubleForRandomIntegerVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                RandomDoubleForRandomIntegerVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String nextDouble = "nextDouble";
            if (!"nextDouble".equals(methodName)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.util.Random".equals(className)) {
                return;
            }
            PsiExpression possibleMultiplierExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)call);
            if (!RandomDoubleForRandomIntegerVisitor.isMultiplier(possibleMultiplierExpression)) {
                return;
            }
            PsiExpression possibleIntCastExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression(possibleMultiplierExpression);
            if (!RandomDoubleForRandomIntegerVisitor.isIntCast(possibleIntCastExpression)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isMultiplier(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (!(expression2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.ASTERISK.equals(tokenType);
        }

        private static boolean isIntCast(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (!(expression2 instanceof PsiTypeCastExpression)) {
                return false;
            }
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression2;
            PsiType type2 = castExpression.getType();
            return PsiType.INT.equals((Object)type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection$RandomDoubleForRandomIntegerVisitor", "visitMethodCallExpression"));
        }
    }

    private static class RandomDoubleForRandomIntegerFix
    extends InspectionGadgetsFix {
        private RandomDoubleForRandomIntegerFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("random.double.for.random.integer.replace.quickfix", new Object[0]);
            if (string == null) {
                RandomDoubleForRandomIntegerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiIdentifier name2 = (PsiIdentifier)descriptor2.getPsiElement();
            PsiReferenceExpression expression2 = (PsiReferenceExpression)name2.getParent();
            if (expression2 == null) {
                return;
            }
            PsiExpression call = (PsiExpression)expression2.getParent();
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            PsiBinaryExpression multiplication = (PsiBinaryExpression)RandomDoubleForRandomIntegerInspection.getContainingExpression(call);
            if (multiplication == null) {
                return;
            }
            PsiExpression cast = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)multiplication);
            if (cast == null) {
                return;
            }
            PsiExpression lhs = multiplication.getLOperand();
            PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
            PsiExpression multiplierExpression = call.equals(strippedLhs) ? multiplication.getROperand() : lhs;
            assert (multiplierExpression != null);
            String multiplierText = multiplierExpression.getText();
            String nextInt = ".nextInt((int) ";
            PsiReplacementUtil.replaceExpression(cast, qualifierText + ".nextInt((int) " + multiplierText + ')');
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection$RandomDoubleForRandomIntegerFix", "getFamilyName"));
        }
    }
}

