/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationSearchUtils {
    private DeclarationSearchUtils() {
    }

    public static boolean variableNameResolvesToTarget(@NotNull String variableName, @NotNull PsiVariable target2, @NotNull PsiElement context) {
        if (variableName == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(2);
        }
        Project project2 = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiResolveHelper resolveHelper = psiFacade.getResolveHelper();
        PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(variableName, context);
        return target2.equals(variable);
    }

    public static boolean containsConflictingDeclarations(PsiCodeBlock block, PsiCodeBlock parentBlock) {
        PsiStatement[] statements = block.getStatements();
        if (statements.length == 0) {
            return false;
        }
        ArrayList<PsiCodeBlock> followingBlocks = new ArrayList<PsiCodeBlock>();
        DeclarationSearchUtils.collectFollowingBlocks(block.getParent().getNextSibling(), followingBlocks);
        Project project2 = block.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        for (PsiStatement statement2 : statements) {
            PsiElement[] variables;
            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement2;
            for (PsiElement variable : variables = declaration2.getDeclaredElements()) {
                PsiLocalVariable localVariable;
                String variableName;
                if (!(variable instanceof PsiLocalVariable) || (variableName = (localVariable = (PsiLocalVariable)variable).getName()) == null) continue;
                PsiVariable target2 = resolveHelper.resolveAccessibleReferencedVariable(variableName, (PsiElement)parentBlock);
                if (target2 instanceof PsiLocalVariable) {
                    return true;
                }
                for (PsiCodeBlock codeBlock : followingBlocks) {
                    PsiVariable target1 = resolveHelper.resolveAccessibleReferencedVariable(variableName, (PsiElement)codeBlock);
                    if (!(target1 instanceof PsiLocalVariable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void collectFollowingBlocks(PsiElement element, List<PsiCodeBlock> out) {
        while (element != null) {
            if (element instanceof PsiCodeBlock) {
                out.add((PsiCodeBlock)element);
            }
            DeclarationSearchUtils.collectFollowingBlocks(element.getFirstChild(), out);
            element = element.getNextSibling();
        }
    }

    public static PsiExpression findDefinition(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiVariable variable) {
        PsiCodeBlock block;
        if (referenceExpression == null) {
            DeclarationSearchUtils.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            PsiElement target2 = referenceExpression.resolve();
            if (!(target2 instanceof PsiVariable)) {
                return null;
            }
            variable = (PsiVariable)target2;
        }
        if ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
            return null;
        }
        PsiElement[] defs = DefUseUtil.getDefs(block, variable, (PsiElement)referenceExpression);
        if (defs.length != 1) {
            return null;
        }
        PsiElement def = defs[0];
        if (def instanceof PsiVariable) {
            PsiVariable target3 = (PsiVariable)def;
            PsiExpression initializer = target3.getInitializer();
            return ParenthesesUtils.stripParentheses(initializer);
        }
        if (def instanceof PsiReferenceExpression) {
            PsiElement parent = def.getParent();
            if (!(parent instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            if (assignmentExpression.getOperationTokenType() != JavaTokenType.EQ) {
                return null;
            }
            return ParenthesesUtils.stripParentheses(assignmentExpression.getRExpression());
        }
        return null;
    }

    public static boolean isTooExpensiveToSearch(PsiNamedElement element, boolean zeroResult) {
        String name2 = element.getName();
        if (name2 == null) {
            return true;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        SearchScope useScope = element.getUseScope();
        if (!(useScope instanceof GlobalSearchScope)) {
            return zeroResult;
        }
        PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(name2, (GlobalSearchScope)useScope, null, progressManager.getProgressIndicator());
        if (cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            return zeroResult;
        }
        return cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/DeclarationSearchUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "variableNameResolvesToTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

