/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakestTypeFinder {
    private WeakestTypeFinder() {
    }

    @NotNull
    public static Collection<PsiClass> calculateWeakestClassesNecessary(@NotNull PsiElement variableOrMethod, boolean useRighthandTypeAsWeakestTypeInAssignments, boolean useParameterizedTypeForCollectionMethods) {
        PsiClass lowerBoundClass;
        PsiType variableOrMethodType;
        if (variableOrMethod == null) {
            WeakestTypeFinder.$$$reportNull$$$0(0);
        }
        if (variableOrMethod instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)variableOrMethod;
            variableOrMethodType = variable.getType();
        } else if (variableOrMethod instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)variableOrMethod;
            variableOrMethodType = method.getReturnType();
            if (PsiType.VOID.equals((Object)variableOrMethodType)) {
                List<PsiClass> list2 = Collections.emptyList();
                if (list2 == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(1);
                }
                return list2;
            }
        } else {
            throw new IllegalArgumentException("PsiMethod or PsiVariable expected: " + variableOrMethod);
        }
        PsiClass variableOrMethodClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variableOrMethodType);
        if (variableOrMethodClass == null || variableOrMethodClass instanceof PsiTypeParameter) {
            List<PsiClass> list3 = Collections.emptyList();
            if (list3 == null) {
                WeakestTypeFinder.$$$reportNull$$$0(2);
            }
            return list3;
        }
        Set<PsiClass> weakestTypeClasses = new HashSet<PsiClass>();
        GlobalSearchScope scope = variableOrMethod.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)variableOrMethod.getProject());
        if (variableOrMethod instanceof PsiResourceVariable) {
            lowerBoundClass = facade.findClass("java.lang.AutoCloseable", scope);
            if (lowerBoundClass == null || variableOrMethodClass.equals(lowerBoundClass)) {
                List<PsiClass> list4 = Collections.emptyList();
                if (list4 == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(3);
                }
                return list4;
            }
            weakestTypeClasses.add(lowerBoundClass);
            PsiResourceVariable resourceVariable = (PsiResourceVariable)variableOrMethod;
            String methodCallText = resourceVariable.getName() + ".close()";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)facade.getElementFactory().createExpressionFromText(methodCallText, resourceVariable.getParent());
            if (!WeakestTypeFinder.findWeakestType(methodCallExpression, weakestTypeClasses)) {
                List<PsiClass> list5 = Collections.emptyList();
                if (list5 == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(4);
                }
                return list5;
            }
            if (weakestTypeClasses.isEmpty()) {
                weakestTypeClasses.add(lowerBoundClass);
            }
        } else {
            lowerBoundClass = facade.findClass("java.lang.Object", scope);
            if (lowerBoundClass == null || variableOrMethodClass.equals(lowerBoundClass)) {
                List<PsiClass> list6 = Collections.emptyList();
                if (list6 == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(5);
                }
                return list6;
            }
            weakestTypeClasses.add(lowerBoundClass);
        }
        Query query = ReferencesSearch.search((PsiElement)variableOrMethod, (SearchScope)variableOrMethod.getUseScope());
        boolean hasUsages = false;
        for (PsiReference reference : query) {
            PsiMethodCallExpression methodCallExpression;
            PsiType type2;
            ProgressManager.checkCanceled();
            if (reference == null) continue;
            hasUsages = true;
            PsiElement referenceElement = reference.getElement();
            PsiElement referenceParent = referenceElement.getParent();
            if (referenceParent instanceof PsiMethodCallExpression) {
                referenceElement = referenceParent;
                referenceParent = referenceElement.getParent();
            }
            PsiElement referenceGrandParent = referenceParent.getParent();
            if (reference instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)reference;
                type2 = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type2);
                if (!PsiType.VOID.equals((Object)returnType) && !WeakestTypeFinder.checkType(returnType, weakestTypeClasses)) {
                    List<PsiClass> list7 = Collections.emptyList();
                    if (list7 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(6);
                    }
                    return list7;
                }
            } else if (referenceParent instanceof PsiExpressionList) {
                if (!(referenceGrandParent instanceof PsiMethodCallExpression)) {
                    List<PsiClass> list8 = Collections.emptyList();
                    if (list8 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(7);
                    }
                    return list8;
                }
                methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, methodCallExpression, useParameterizedTypeForCollectionMethods, weakestTypeClasses)) {
                    List<PsiClass> list9 = Collections.emptyList();
                    if (list9 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(8);
                    }
                    return list9;
                }
            } else if (referenceGrandParent instanceof PsiMethodCallExpression) {
                methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (PsiUtil.skipParenthesizedExprUp((PsiElement)methodCallExpression.getParent()) instanceof PsiTypeCastExpression || !WeakestTypeFinder.findWeakestType(methodCallExpression, weakestTypeClasses)) {
                    List<PsiClass> list10 = Collections.emptyList();
                    if (list10 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(9);
                    }
                    return list10;
                }
            } else if (referenceParent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, assignmentExpression, useRighthandTypeAsWeakestTypeInAssignments, weakestTypeClasses)) {
                    List<PsiClass> list11 = Collections.emptyList();
                    if (list11 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(10);
                    }
                    return list11;
                }
            } else if (referenceParent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)referenceParent;
                type2 = variable.getType();
                if (!type2.isAssignableFrom(variableOrMethodType) || !WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List<PsiClass> list12 = Collections.emptyList();
                    if (list12 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(11);
                    }
                    return list12;
                }
            } else if (referenceParent instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)referenceParent;
                if (!Comparing.equal((Object)foreachStatement.getIteratedValue(), (Object)referenceElement)) {
                    List<PsiClass> list13 = Collections.emptyList();
                    if (list13 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(12);
                    }
                    return list13;
                }
                PsiClass javaLangIterableClass = facade.findClass("java.lang.Iterable", scope);
                if (javaLangIterableClass == null) {
                    List<PsiClass> list14 = Collections.emptyList();
                    if (list14 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(13);
                    }
                    return list14;
                }
                WeakestTypeFinder.checkClass(javaLangIterableClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiReturnStatement) {
                PsiType type3 = PsiTypesUtil.getMethodReturnType((PsiElement)referenceParent);
                if (!WeakestTypeFinder.checkType(type3, weakestTypeClasses)) {
                    List<PsiClass> list15 = Collections.emptyList();
                    if (list15 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(14);
                    }
                    return list15;
                }
            } else if (referenceParent instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)referenceParent;
                PsiElement target2 = referenceExpression.resolve();
                if (!(target2 instanceof PsiField)) {
                    List<PsiClass> list16 = Collections.emptyList();
                    if (list16 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(15);
                    }
                    return list16;
                }
                PsiField field = (PsiField)target2;
                PsiClass containingClass = field.getContainingClass();
                WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(arrayInitializerExpression, weakestTypeClasses)) {
                    List<PsiClass> list17 = Collections.emptyList();
                    if (list17 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(16);
                    }
                    return list17;
                }
            } else if (referenceParent instanceof PsiThrowStatement) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(throwStatement, variableOrMethodClass, weakestTypeClasses)) {
                    List<PsiClass> list18 = Collections.emptyList();
                    if (list18 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(17);
                    }
                    return list18;
                }
            } else if (referenceParent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)referenceParent;
                PsiExpression condition2 = conditionalExpression.getCondition();
                if (referenceElement.equals(condition2)) {
                    List<PsiClass> list19 = Collections.emptyList();
                    if (list19 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(18);
                    }
                    return list19;
                }
                PsiType type4 = ExpectedTypeUtils.findExpectedType((PsiExpression)conditionalExpression, true);
                if (!WeakestTypeFinder.checkType(type4, weakestTypeClasses)) {
                    List<PsiClass> list20 = Collections.emptyList();
                    if (list20 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(19);
                    }
                    return list20;
                }
            } else if (referenceParent instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)referenceParent;
                type2 = binaryExpression.getType();
                if (variableOrMethodType.equals(type2) && !WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List<PsiClass> list21 = Collections.emptyList();
                    if (list21 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(20);
                    }
                    return list21;
                }
            } else {
                PsiNewExpression newExpression;
                PsiExpression qualifier;
                if (referenceParent instanceof PsiSwitchStatement) {
                    List<PsiClass> list22 = Collections.emptyList();
                    if (list22 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(21);
                    }
                    return list22;
                }
                if (referenceParent instanceof PsiUnaryExpression) {
                    List<PsiClass> list23 = Collections.emptyList();
                    if (list23 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(22);
                    }
                    return list23;
                }
                if (referenceParent instanceof PsiIfStatement) {
                    List<PsiClass> list24 = Collections.emptyList();
                    if (list24 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(23);
                    }
                    return list24;
                }
                if (referenceParent instanceof PsiForStatement) {
                    List<PsiClass> list25 = Collections.emptyList();
                    if (list25 == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(24);
                    }
                    return list25;
                }
                if (referenceParent instanceof PsiNewExpression && (qualifier = (newExpression = (PsiNewExpression)referenceParent).getQualifier()) != null) {
                    PsiClass innerClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)newExpression.getType());
                    if (innerClass == null) {
                        List<PsiClass> list26 = Collections.emptyList();
                        if (list26 == null) {
                            WeakestTypeFinder.$$$reportNull$$$0(25);
                        }
                        return list26;
                    }
                    PsiClass outerClass = innerClass.getContainingClass();
                    if (outerClass != null) {
                        WeakestTypeFinder.checkClass(outerClass, weakestTypeClasses);
                    }
                }
            }
            if (!weakestTypeClasses.contains(variableOrMethodClass) && !weakestTypeClasses.isEmpty()) continue;
            List<PsiClass> list27 = Collections.emptyList();
            if (list27 == null) {
                WeakestTypeFinder.$$$reportNull$$$0(26);
            }
            return list27;
        }
        if (!hasUsages) {
            List<PsiClass> list28 = Collections.emptyList();
            if (list28 == null) {
                WeakestTypeFinder.$$$reportNull$$$0(27);
            }
            return list28;
        }
        Set<PsiClass> set2 = weakestTypeClasses = WeakestTypeFinder.filterAccessibleClasses(weakestTypeClasses, variableOrMethodClass, variableOrMethod);
        if (set2 == null) {
            WeakestTypeFinder.$$$reportNull$$$0(28);
        }
        return set2;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiMethodCallExpression methodCallExpression, boolean useParameterizedTypeForCollectionMethods, Set<PsiClass> weakestTypeClasses) {
        PsiClassType classType;
        PsiType[] parameterTypes;
        PsiType qualifierType;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifier;
        PsiClass containingClass;
        PsiType type2;
        if (!(referenceElement instanceof PsiExpression)) {
            return false;
        }
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null) {
            return false;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiExpressionList expressionList = methodCallExpression.getArgumentList();
        Object[] expressions2 = expressionList.getExpressions();
        int index = ArrayUtil.indexOf((Object[])expressions2, (Object)referenceElement);
        if (index < 0) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 0) {
            return false;
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (index < parameters2.length) {
            PsiParameter parameter2 = parameters2[index];
            type2 = parameter2.getType();
        } else {
            PsiParameter parameter3 = parameters2[parameters2.length - 1];
            type2 = parameter3.getType();
            if (!(type2 instanceof PsiEllipsisType)) {
                return false;
            }
        }
        if (!useParameterizedTypeForCollectionMethods) {
            return WeakestTypeFinder.checkType(type2, substitutor, weakestTypeClasses);
        }
        String methodName = method.getName();
        if (("remove".equals(methodName) || "get".equals(methodName) || "containsKey".equals(methodName) || "containsValue".equals(methodName) || "contains".equals(methodName) || "indexOf".equals(methodName) || "lastIndexOf".equals(methodName)) && (InheritanceUtil.isInheritor((PsiClass)(containingClass = method.getContainingClass()), (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection")) && (qualifier = (methodExpression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (parameterTypes = (classType = (PsiClassType)qualifierType).getParameters()).length > 0) {
            PsiType parameterType = parameterTypes[0];
            Object expression2 = expressions2[index];
            PsiType expressionType = expression2.getType();
            if (expressionType == null || parameterType == null || !parameterType.isAssignableFrom(expressionType)) {
                return false;
            }
            return WeakestTypeFinder.checkType(parameterType, substitutor, weakestTypeClasses);
        }
        return WeakestTypeFinder.checkType(type2, substitutor, weakestTypeClasses);
    }

    private static boolean checkType(@Nullable PsiType type2, @NotNull PsiSubstitutor substitutor, @NotNull Collection<PsiClass> weakestTypeClasses) {
        PsiClass aClass;
        if (substitutor == null) {
            WeakestTypeFinder.$$$reportNull$$$0(29);
        }
        if (weakestTypeClasses == null) {
            WeakestTypeFinder.$$$reportNull$$$0(30);
        }
        if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) == null) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter) {
            PsiType substitution = substitutor.substitute((PsiTypeParameter)aClass);
            return WeakestTypeFinder.checkType(substitution, weakestTypeClasses);
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    private static boolean findWeakestType(PsiMethodCallExpression methodCallExpression, Set<PsiClass> weakestTypeClasses) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiClassType[] classTypes = throwsList.getReferencedTypes();
        HashSet<PsiClassType> thrownTypes = new HashSet<PsiClassType>(Arrays.asList(classTypes));
        List<PsiMethod> superMethods = WeakestTypeFinder.findAllSuperMethods(method);
        boolean checked = false;
        if (!superMethods.isEmpty()) {
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)methodCallExpression, false);
            for (PsiMethod superMethod : superMethods) {
                PsiClass containingClass;
                PsiType returnType = superMethod.getReturnType();
                if (expectedType instanceof PsiClassType) {
                    if (!(returnType instanceof PsiClassType)) continue;
                    PsiClassType expectedClassType = (PsiClassType)expectedType;
                    expectedClassType.rawType().isAssignableFrom(returnType);
                } else if (expectedType != null && returnType != null && !expectedType.isAssignableFrom(returnType)) continue;
                if (WeakestTypeFinder.throwsIncompatibleException(superMethod, thrownTypes) || !PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)methodCallExpression, null) || !WeakestTypeFinder.checkClass(containingClass = superMethod.getContainingClass(), weakestTypeClasses)) continue;
                checked = true;
                break;
            }
        }
        if (!checked) {
            if (TypeUtils.isTypeParameter(method.getReturnType())) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
        }
        return true;
    }

    private static List<PsiMethod> findAllSuperMethods(PsiMethod method) {
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).forEach(method12 -> {
            result2.add(method12.getMethod());
            return true;
        });
        Collections.sort(result2, (method1, method2) -> {
            PsiClass aClass1 = method1.getContainingClass();
            PsiClass aClass2 = method2.getContainingClass();
            if (aClass1 == null || aClass2 == null || aClass1.equals(aClass2)) {
                return 0;
            }
            if (aClass1.isInterface() && !aClass2.isInterface()) {
                return -1;
            }
            if (!aClass1.isInterface() && aClass2.isInterface()) {
                return 1;
            }
            if (aClass1.isInheritor(aClass2, true)) {
                return 1;
            }
            if (aClass2.isInheritor(aClass1, true)) {
                return -1;
            }
            String name1 = aClass1.getName();
            String name2 = aClass2.getName();
            return name1.compareTo(name2);
        });
        return result2;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiAssignmentExpression assignmentExpression, boolean useRighthandTypeAsWeakestTypeInAssignments, Set<PsiClass> weakestTypeClasses) {
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        if (JavaTokenType.EQ != tokenType) {
            return false;
        }
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        if (rhs == null) {
            return false;
        }
        PsiType lhsType = lhs.getType();
        PsiType rhsType = rhs.getType();
        if (lhsType == null || rhsType == null || !lhsType.isAssignableFrom(rhsType)) {
            return false;
        }
        return !(referenceElement.equals(rhs) ? !WeakestTypeFinder.checkType(lhsType, weakestTypeClasses) : useRighthandTypeAsWeakestTypeInAssignments && (!(rhs instanceof PsiNewExpression) || !(rhs instanceof PsiTypeCastExpression)) && lhsType.equals(rhsType));
    }

    private static boolean findWeakestType(PsiArrayInitializerExpression arrayInitializerExpression, Set<PsiClass> weakestTypeClasses) {
        PsiType type2 = arrayInitializerExpression.getType();
        if (!(type2 instanceof PsiArrayType)) {
            return false;
        }
        PsiArrayType arrayType = (PsiArrayType)type2;
        PsiType componentType = arrayType.getComponentType();
        return WeakestTypeFinder.checkType(componentType, weakestTypeClasses);
    }

    private static boolean findWeakestType(PsiThrowStatement throwStatement, PsiClass variableOrMethodClass, Set<PsiClass> weakestTypeClasses) {
        PsiClassType runtimeExceptionType = TypeUtils.getType("java.lang.RuntimeException", (PsiElement)throwStatement);
        PsiClass runtimeExceptionClass = runtimeExceptionType.resolve();
        if (runtimeExceptionClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)runtimeExceptionClass, (boolean)true)) {
            if (!WeakestTypeFinder.checkType((PsiType)runtimeExceptionType, weakestTypeClasses)) {
                return false;
            }
        } else {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)throwStatement, PsiMethod.class);
            if (method == null) {
                return false;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] referencedTypes = throwsList.getReferencedTypes();
            boolean checked = false;
            for (PsiClassType referencedType : referencedTypes) {
                PsiClass throwableClass = referencedType.resolve();
                if (throwableClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)throwableClass, (boolean)true) || !WeakestTypeFinder.checkType((PsiType)referencedType, weakestTypeClasses)) continue;
                checked = true;
                break;
            }
            if (!checked) {
                return false;
            }
        }
        return true;
    }

    private static boolean throwsIncompatibleException(PsiMethod method, Collection<PsiClassType> exceptionTypes) {
        PsiClassType[] superThrownTypes;
        PsiReferenceList superThrowsList = method.getThrowsList();
        block0: for (PsiClassType superThrownType : superThrownTypes = superThrowsList.getReferencedTypes()) {
            if (exceptionTypes.contains(superThrownType)) continue;
            for (PsiClassType exceptionType : exceptionTypes) {
                if (!InheritanceUtil.isInheritor((PsiType)superThrownType, (String)exceptionType.getCanonicalText())) continue;
                continue block0;
            }
            PsiClass aClass = superThrownType.resolve();
            if (aClass == null) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Error")) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    private static boolean checkType(@Nullable PsiType type2, @NotNull Collection<PsiClass> weakestTypeClasses) {
        PsiClass aClass;
        if (weakestTypeClasses == null) {
            WeakestTypeFinder.$$$reportNull$$$0(31);
        }
        if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) == null) {
            return false;
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    public static Set<PsiClass> filterAccessibleClasses(Set<PsiClass> weakestTypeClasses, PsiClass upperBound, PsiElement context) {
        HashSet<PsiClass> result2 = new HashSet<PsiClass>();
        for (PsiClass weakestTypeClass : weakestTypeClasses) {
            if (PsiUtil.isAccessible((PsiMember)weakestTypeClass, (PsiElement)context, null) && !weakestTypeClass.isDeprecated()) {
                result2.add(weakestTypeClass);
                continue;
            }
            PsiClass visibleInheritor = WeakestTypeFinder.getVisibleInheritor(weakestTypeClass, upperBound, context);
            if (visibleInheritor == null) continue;
            result2.add(visibleInheritor);
        }
        return result2;
    }

    @Nullable
    private static PsiClass getVisibleInheritor(@NotNull PsiClass superClass, PsiClass upperBound, PsiElement context) {
        if (superClass == null) {
            WeakestTypeFinder.$$$reportNull$$$0(32);
        }
        Query search2 = DirectClassInheritorsSearch.search((PsiClass)superClass, (SearchScope)context.getResolveScope());
        Project project2 = superClass.getProject();
        for (PsiClass aClass : search2) {
            if (!aClass.isInheritor(superClass, true) || !upperBound.isInheritor(aClass, true)) continue;
            if (PsiUtil.isAccessible((Project)project2, (PsiMember)aClass, (PsiElement)context, null)) {
                return aClass;
            }
            return WeakestTypeFinder.getVisibleInheritor(aClass, upperBound, context);
        }
        return null;
    }

    private static boolean checkClass(@Nullable PsiClass aClass, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (weakestTypeClasses == null) {
            WeakestTypeFinder.$$$reportNull$$$0(33);
        }
        if (aClass == null) {
            return false;
        }
        boolean shouldAdd = true;
        Iterator<PsiClass> iterator = weakestTypeClasses.iterator();
        while (iterator.hasNext()) {
            PsiClass weakestTypeClass = iterator.next();
            if (weakestTypeClass.equals(aClass)) {
                return true;
            }
            if (aClass.isInheritor(weakestTypeClass, true)) {
                iterator.remove();
                continue;
            }
            if (weakestTypeClass.isInheritor(aClass, true)) {
                shouldAdd = false;
                continue;
            }
            iterator.remove();
            shouldAdd = false;
        }
        if (!shouldAdd) {
            return false;
        }
        weakestTypeClasses.add(aClass);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/WeakestTypeFinder";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weakestTypeClasses";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/WeakestTypeFinder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateWeakestClassesNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateWeakestClassesNecessary";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleInheritor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

