/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizeReplaceableByIsEmptyInspectionBase
extends BaseInspection {
    public boolean ignoreNegations = false;
    public OrderedSet<String> ignoredTypes = new OrderedSet();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.display.name", new Object[0]);
        if (string == null) {
            SizeReplaceableByIsEmptyInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", infos[0]);
        if (string == null) {
            SizeReplaceableByIsEmptyInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SizeReplaceableByIsEmptyVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SizeReplaceableByIsEmptyFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/SizeReplaceableByIsEmptyInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SizeReplaceableByIsEmptyVisitor
    extends BaseInspectionVisitor {
        private SizeReplaceableByIsEmptyVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            String replacementIsEmptyCall;
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                String replacementIsEmptyCall2 = this.getReplacementIsEmptyCall(lhs, rhs, false, expression2.getOperationTokenType());
                if (replacementIsEmptyCall2 != null) {
                    this.registerError((PsiElement)expression2, replacementIsEmptyCall2);
                }
            } else if (rhs instanceof PsiMethodCallExpression && (replacementIsEmptyCall = this.getReplacementIsEmptyCall(rhs, lhs, true, expression2.getOperationTokenType())) != null) {
                this.registerError((PsiElement)expression2, replacementIsEmptyCall);
            }
        }

        @Nullable
        private String getReplacementIsEmptyCall(PsiExpression lhs, PsiExpression rhs, boolean flipped, IElementType tokenType) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            String isEmptyCall = this.getIsEmptyCall(callExpression);
            if (isEmptyCall == null) {
                return null;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return null;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            if (constant != 0) {
                return null;
            }
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                return isEmptyCall;
            }
            if (SizeReplaceableByIsEmptyInspectionBase.this.ignoreNegations) {
                return null;
            }
            if (JavaTokenType.NE.equals(tokenType)) {
                return '!' + isEmptyCall;
            }
            if (flipped ? JavaTokenType.LT.equals(tokenType) : JavaTokenType.GT.equals(tokenType)) {
                return '!' + isEmptyCall;
            }
            return null;
        }

        @Nullable
        private String getIsEmptyCall(PsiMethodCallExpression callExpression) {
            PsiMethod[] methods;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"size".equals(referenceName) && !"length".equals(referenceName)) {
                return null;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 0) {
                return null;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return null;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression2.getType());
            if (aClass == null || PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)callExpression, (boolean)true)) {
                return null;
            }
            for (String ignoredType : SizeReplaceableByIsEmptyInspectionBase.this.ignoredTypes) {
                if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)ignoredType)) continue;
                return null;
            }
            for (PsiMethod method : methods = aClass.findMethodsByName("isEmpty", true)) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                return qualifierExpression2.getText() + ".isEmpty()";
            }
            return null;
        }
    }

    protected static class SizeReplaceableByIsEmptyFix
    extends InspectionGadgetsFix {
        protected SizeReplaceableByIsEmptyFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.quickfix", new Object[0]);
            if (string == null) {
                SizeReplaceableByIsEmptyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)descriptor2.getPsiElement();
            PsiExpression operand2 = binaryExpression.getLOperand();
            if (!(operand2 instanceof PsiMethodCallExpression)) {
                operand2 = binaryExpression.getROperand();
            }
            if (!(operand2 instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return;
            }
            String newExpression = qualifierExpression2.getText();
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.EQEQ.equals(tokenType)) {
                newExpression = '!' + newExpression;
            }
            newExpression = newExpression + ".isEmpty()";
            PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SizeReplaceableByIsEmptyInspectionBase$SizeReplaceableByIsEmptyFix", "getFamilyName"));
        }
    }
}

