/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public class NotifyWithoutCorrespondingWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("notify.without.corresponding.wait.display.name", new Object[0]);
        if (string == null) {
            NotifyWithoutCorrespondingWaitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("notify.without.corresponding.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            NotifyWithoutCorrespondingWaitInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWithoutCorrespondingNotifyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/NotifyWithoutCorrespondingWaitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ContainsWaitVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiField target;
        private boolean containsWait;

        ContainsWaitVisitor(PsiField target2) {
            this.target = target2;
        }

        public void visitElement(PsiElement element) {
            if (this.containsWait) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isWaitCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (referent == null) {
                return;
            }
            if (!this.target.equals(referent)) {
                return;
            }
            this.containsWait = true;
        }

        boolean containsWait() {
            return this.containsWait;
        }
    }

    private static class WaitWithoutCorrespondingNotifyVisitor
    extends BaseInspectionVisitor {
        private WaitWithoutCorrespondingNotifyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                WaitWithoutCorrespondingNotifyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)fieldClass, (PsiElement)expression2, (boolean)true)) {
                return;
            }
            if (WaitWithoutCorrespondingNotifyVisitor.containsWaitCall(fieldClass, field)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean containsWaitCall(PsiClass fieldClass, PsiField field) {
            ContainsWaitVisitor visitor = new ContainsWaitVisitor(field);
            fieldClass.accept((PsiElementVisitor)visitor);
            return visitor.containsWait();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/NotifyWithoutCorrespondingWaitInspection$WaitWithoutCorrespondingNotifyVisitor", "visitMethodCallExpression"));
        }
    }
}

