/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CommentOnLineWithSourcePredicate;
import org.jetbrains.annotations.NotNull;

public class MoveCommentToSeparateLineIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CommentOnLineWithSourcePredicate commentOnLineWithSourcePredicate = new CommentOnLineWithSourcePredicate();
        if (commentOnLineWithSourcePredicate == null) {
            MoveCommentToSeparateLineIntention.$$$reportNull$$$0(0);
        }
        return commentOnLineWithSourcePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        String newline;
        PsiElement prevLeaf;
        if (element == null) {
            MoveCommentToSeparateLineIntention.$$$reportNull$$$0(1);
        }
        PsiComment comment = (PsiComment)element;
        while (true) {
            if ((prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element)) == null || prevLeaf instanceof PsiWhiteSpace && prevLeaf.getText().indexOf(10) >= 0) break;
            element = prevLeaf;
        }
        PsiWhiteSpace whitespace = (PsiWhiteSpace)prevLeaf;
        PsiElement anchor = element;
        Project project2 = comment.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(comment.getContainingFile());
        if (document == null) {
            return;
        }
        if (whitespace == null) {
            newline = "\n";
        } else {
            String text2 = whitespace.getText();
            newline = text2.substring(text2.lastIndexOf(10));
        }
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)comment);
        TextRange commentRange = comment.getTextRange();
        int deleteOffset = prev instanceof PsiWhiteSpace ? prev.getTextRange().getStartOffset() : commentRange.getStartOffset();
        document.deleteString(deleteOffset, commentRange.getEndOffset());
        int offset = anchor.getTextRange().getStartOffset();
        document.insertString(offset, (CharSequence)newline);
        document.insertString(offset, (CharSequence)comment.getText());
        MoveCommentToSeparateLineIntention.scrollToVisible(project2, offset);
    }

    private static void scrollToVisible(Project project2, int offset) {
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        LogicalPosition position = editor.offsetToLogicalPosition(offset);
        editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/comment/MoveCommentToSeparateLineIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/comment/MoveCommentToSeparateLineIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

