/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.commutative.SwapMethodCallArgumentsPredicate;
import org.jetbrains.annotations.NotNull;

public class SwapMethodCallArgumentsIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        SwapMethodCallArgumentsPredicate swapMethodCallArgumentsPredicate = new SwapMethodCallArgumentsPredicate();
        if (swapMethodCallArgumentsPredicate == null) {
            SwapMethodCallArgumentsIntention.$$$reportNull$$$0(0);
        }
        return swapMethodCallArgumentsPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiExpressionList expressionList = (PsiExpressionList)element;
        PsiExpression[] expressions2 = expressionList.getExpressions();
        PsiExpression firstExpression = expressions2[0];
        PsiExpression secondExpression = expressions2[1];
        return IntentionPowerPackBundle.message("swap.method.call.arguments.intention.name", StringUtil.first((String)firstExpression.getText(), (int)20, (boolean)true), StringUtil.first((String)secondExpression.getText(), (int)20, (boolean)true));
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        Object newExpression;
        String callText;
        if (element == null) {
            SwapMethodCallArgumentsIntention.$$$reportNull$$$0(1);
        }
        PsiExpressionList argumentList = (PsiExpressionList)element;
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression firstArgument = arguments[0];
        PsiExpression secondArgument = arguments[1];
        String firstArgumentText = firstArgument.getText();
        String secondArgumentText = secondArgument.getText();
        PsiCallExpression callExpression = (PsiCallExpression)argumentList.getParent();
        if (callExpression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)callExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            callText = methodExpression.getText();
        } else if (callExpression instanceof PsiNewExpression) {
            newExpression = (PsiNewExpression)callExpression;
            PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
            assert (classReference2 != null);
            callText = "new " + classReference2.getText();
        } else {
            return;
        }
        newExpression = callText + '(' + secondArgumentText + ", " + firstArgumentText + ')';
        PsiReplacementUtil.replaceExpression((PsiExpression)callExpression, (String)newExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/commutative/SwapMethodCallArgumentsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/commutative/SwapMethodCallArgumentsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

