/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.Jdk5StringConcatenationPredicate;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithFormatStringIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        Jdk5StringConcatenationPredicate jdk5StringConcatenationPredicate = new Jdk5StringConcatenationPredicate();
        if (jdk5StringConcatenationPredicate == null) {
            ReplaceConcatenationWithFormatStringIntention.$$$reportNull$$$0(0);
        }
        return jdk5StringConcatenationPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ReplaceConcatenationWithFormatStringIntention.$$$reportNull$$$0(1);
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiElement parent = expression2.getParent();
        while (ExpressionUtils.isConcatenation(parent)) {
            expression2 = (PsiPolyadicExpression)parent;
            parent = expression2.getParent();
        }
        StringBuilder formatString = new StringBuilder();
        ArrayList<PsiExpression> formatParameters = new ArrayList<PsiExpression>();
        PsiConcatenationUtil.buildFormatString((PsiExpression)expression2, (StringBuilder)formatString, formatParameters, (boolean)true);
        if (ReplaceConcatenationWithFormatStringIntention.replaceWithPrintfExpression((PsiExpression)expression2, formatString, formatParameters)) {
            return;
        }
        StringBuilder newExpression = new StringBuilder();
        newExpression.append("java.lang.String.format(\"");
        newExpression.append((CharSequence)formatString);
        newExpression.append('\"');
        for (PsiExpression formatParameter : formatParameters) {
            newExpression.append(", ");
            newExpression.append(formatParameter.getText());
        }
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression.toString());
    }

    private static boolean replaceWithPrintfExpression(PsiExpression expression2, CharSequence formatString, List<PsiExpression> formatParameters) {
        boolean insertNewline;
        PsiElement expressionParent = expression2.getParent();
        if (!(expressionParent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = expressionParent.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name2 = methodExpression.getReferenceName();
        if ("println".equals(name2)) {
            insertNewline = true;
        } else if ("print".equals(name2)) {
            insertNewline = false;
        } else {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (!"java.io.PrintStream".equals(qualifiedName) && !"java.io.Printwriter".equals(qualifiedName)) {
            return false;
        }
        StringBuilder newExpression = new StringBuilder();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            newExpression.append(qualifier.getText()).append('.');
        }
        newExpression.append("printf(\"").append(formatString);
        if (insertNewline) {
            newExpression.append("%n");
        }
        newExpression.append('\"');
        for (PsiExpression formatParameter : formatParameters) {
            newExpression.append(", ").append(formatParameter.getText());
        }
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/concatenation/ReplaceConcatenationWithFormatStringIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/concatenation/ReplaceConcatenationWithFormatStringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

