/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.DetailExceptionsPredicate;
import com.siyeh.ipp.exceptions.HierarchicalTypeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DetailExceptionsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        DetailExceptionsPredicate detailExceptionsPredicate = new DetailExceptionsPredicate();
        if (detailExceptionsPredicate == null) {
            DetailExceptionsIntention.$$$reportNull$$$0(0);
        }
        return detailExceptionsPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiCatchSection[] catchSections;
        PsiCodeBlock tryBlock;
        PsiJavaToken token;
        PsiElement parent;
        if (element == null) {
            DetailExceptionsIntention.$$$reportNull$$$0(1);
        }
        if ((parent = (token = (PsiJavaToken)element).getParent()) instanceof PsiCatchSection) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiTryStatement)) {
            return;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        StringBuilder newTryStatement = new StringBuilder("try");
        HashSet<PsiClassType> exceptionsThrown = new HashSet<PsiClassType>();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            newTryStatement.append(resourceList.getText());
            ExceptionUtils.calculateExceptionsThrown((PsiElement)resourceList, exceptionsThrown);
        }
        if ((tryBlock = tryStatement.getTryBlock()) == null) {
            return;
        }
        String tryBlockText = tryBlock.getText();
        newTryStatement.append(tryBlockText);
        ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock, exceptionsThrown);
        HierarchicalTypeComparator comparator2 = new HierarchicalTypeComparator();
        ArrayList<PsiType> exceptionsAlreadyEmitted = new ArrayList<PsiType>();
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            PsiParameter parameter2 = catchSection.getParameter();
            PsiCodeBlock block = catchSection.getCatchBlock();
            if (parameter2 == null || block == null) continue;
            PsiType caughtType = parameter2.getType();
            ArrayList<PsiType> exceptionsToExpand = new ArrayList<PsiType>(10);
            for (Object e : exceptionsThrown) {
                PsiType thrownType = (PsiType)e;
                if (!caughtType.isAssignableFrom(thrownType)) continue;
                exceptionsToExpand.add(thrownType);
            }
            exceptionsToExpand.removeAll(exceptionsAlreadyEmitted);
            Collections.sort(exceptionsToExpand, comparator2);
            for (PsiType psiType : exceptionsToExpand) {
                newTryStatement.append("catch(").append(psiType.getCanonicalText()).append(' ').append(parameter2.getName()).append(')');
                newTryStatement.append(block.getText());
                exceptionsAlreadyEmitted.add(psiType);
            }
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatement.append("finally").append(finallyBlock.getText());
        }
        String newStatement = newTryStatement.toString();
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)tryStatement, newStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/exceptions/DetailExceptionsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/exceptions/DetailExceptionsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

