/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.AutomaticResourceManagementPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ReplaceArmWithTryFinallyIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AutomaticResourceManagementPredicate automaticResourceManagementPredicate = new AutomaticResourceManagementPredicate();
        if (automaticResourceManagementPredicate == null) {
            ReplaceArmWithTryFinallyIntention.$$$reportNull$$$0(0);
        }
        return automaticResourceManagementPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        int i;
        PsiJavaToken token;
        PsiTryStatement tryStatement;
        if (element == null) {
            ReplaceArmWithTryFinallyIntention.$$$reportNull$$$0(1);
        }
        if ((tryStatement = (PsiTryStatement)(token = (PsiJavaToken)element).getParent()) == null) {
            return;
        }
        boolean replaceAll = tryStatement.getCatchBlocks().length == 0 && tryStatement.getFinallyBlock() == null;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return;
        }
        ArrayList resources = ContainerUtil.newArrayList();
        StringBuilder newTryStatement = new StringBuilder("{");
        for (PsiResourceListElement resource : resourceList) {
            if (resource instanceof PsiResourceVariable) {
                newTryStatement.append(resource.getText()).append(";\n");
                resources.add(((PsiResourceVariable)resource).getName());
            } else {
                resources.add(resource.getText());
            }
            newTryStatement.append("try {");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement[] children2 = tryBlock.getChildren();
        for (i = 1; i < children2.length - 1; ++i) {
            PsiElement child = children2[i];
            newTryStatement.append(child.getText());
        }
        for (i = resources.size() - 1; i >= 0; --i) {
            newTryStatement.append("} finally {\n").append((String)resources.get(i)).append(".close();\n}");
        }
        newTryStatement.append('}');
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiCodeBlock newCodeBlock = factory.createCodeBlockFromText(newTryStatement.toString(), element);
        if (replaceAll) {
            for (PsiStatement newStatement : newCodeBlock.getStatements()) {
                tryStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        } else {
            resourceList.delete();
            tryBlock.replace((PsiElement)newCodeBlock);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/exceptions/ReplaceArmWithTryFinallyIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/exceptions/ReplaceArmWithTryFinallyIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

