/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.increment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.increment.IncrementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineIncrementIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String operator2 = IncrementUtil.getOperatorText(element);
        return operator2 != null ? IntentionPowerPackBundle.message("inline.increment.intention.name", operator2) : null;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        Occurrence occurrence;
        PsiVariable variable;
        if (element == null) {
            InlineIncrementIntention.$$$reportNull$$$0(0);
        }
        PsiReferenceExpression operandExpression = IncrementUtil.getIncrementOrDecrementOperand(element);
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiExpressionStatement.class);
        String operatorText = IncrementUtil.getOperatorText(element);
        if (operandExpression != null && expressionStatement != null && operatorText != null && (variable = InlineIncrementIntention.resolveSimpleVariableReference(operandExpression)) != null && (occurrence = InlineIncrementIntention.findSingleReadOccurrence(expressionStatement, variable)) != null) {
            Project project2 = expressionStatement.getProject();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            String text2 = occurrence.isPrevious ? occurrence.referenceExpression.getText() + operatorText : operatorText + occurrence.referenceExpression.getText();
            PsiExpression incrementOrDecrement = factory.createExpressionFromText(text2, (PsiElement)expressionStatement);
            incrementOrDecrement = (PsiExpression)occurrence.referenceExpression.replace((PsiElement)incrementOrDecrement);
            CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project2);
            codeStyle.reformat((PsiElement)incrementOrDecrement, true);
            CommentTracker ct = new CommentTracker();
            ct.deleteAndRestoreComments((PsiElement)expressionStatement);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = InlineIncrementIntention::isApplicableTo;
        if (psiElementPredicate == null) {
            InlineIncrementIntention.$$$reportNull$$$0(1);
        }
        return psiElementPredicate;
    }

    private static boolean isApplicableTo(PsiElement element) {
        PsiVariable variable;
        PsiReferenceExpression operandExpression = IncrementUtil.getIncrementOrDecrementOperand(element);
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiExpressionStatement.class);
        return operandExpression != null && expressionStatement != null && (variable = InlineIncrementIntention.resolveSimpleVariableReference(operandExpression)) != null && InlineIncrementIntention.findSingleReadOccurrence(expressionStatement, variable) != null;
    }

    @Nullable
    @Contract(value="_, null -> null")
    private static Occurrence findSingleReadOccurrence(@NotNull PsiExpressionStatement statement2, @Nullable PsiVariable variable) {
        if (statement2 == null) {
            InlineIncrementIntention.$$$reportNull$$$0(2);
        }
        if (variable == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiCodeBlock.class, PsiLambdaExpression.class});
        if (parent instanceof PsiCodeBlock) {
            PsiStatement prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement2, PsiStatement.class);
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
            if (prevStatement instanceof PsiExpressionStatement || nextStatement instanceof PsiExpressionStatement) {
                PsiReferenceExpression nextOccurrence;
                PsiReferenceExpression prevOccurrence;
                ControlFlow flow = InlineIncrementIntention.getControlFlow(parent);
                if (prevStatement instanceof PsiExpressionStatement && (prevOccurrence = ControlFlowUtil.findSingleReadOccurrence(flow, (PsiElement)prevStatement, variable)) != null) {
                    return new Occurrence(prevOccurrence, true);
                }
                if (nextStatement instanceof PsiExpressionStatement && (nextOccurrence = ControlFlowUtil.findSingleReadOccurrence(flow, (PsiElement)nextStatement, variable)) != null) {
                    return new Occurrence(nextOccurrence, false);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiVariable resolveSimpleVariableReference(@NotNull PsiReferenceExpression expression2) {
        PsiExpression qualifierExpression2;
        if (expression2 == null) {
            InlineIncrementIntention.$$$reportNull$$$0(3);
        }
        if ((qualifierExpression2 = expression2.getQualifierExpression()) == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
            PsiElement resolved = expression2.resolve();
            return resolved instanceof PsiVariable ? (PsiVariable)resolved : null;
        }
        return null;
    }

    @NotNull
    public static ControlFlow getControlFlow(@NotNull PsiElement body2) {
        ControlFlow controlFlow;
        if (body2 == null) {
            InlineIncrementIntention.$$$reportNull$$$0(4);
        }
        try {
            LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
            controlFlow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow(body2, policy, false, false);
        }
        catch (AnalysisCanceledException e) {
            ControlFlow controlFlow2 = ControlFlow.EMPTY;
            if (controlFlow2 == null) {
                InlineIncrementIntention.$$$reportNull$$$0(6);
            }
            return controlFlow2;
        }
        if (controlFlow == null) {
            InlineIncrementIntention.$$$reportNull$$$0(5);
        }
        return controlFlow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/increment/InlineIncrementIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/increment/InlineIncrementIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSingleReadOccurrence";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleVariableReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Occurrence {
        @NotNull
        final PsiReferenceExpression referenceExpression;
        final boolean isPrevious;

        private Occurrence(@NotNull PsiReferenceExpression referenceExpression, boolean isPrevious) {
            if (referenceExpression == null) {
                Occurrence.$$$reportNull$$$0(0);
            }
            this.referenceExpression = referenceExpression;
            this.isPrevious = isPrevious;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ipp/increment/InlineIncrementIntention$Occurrence", "<init>"));
        }
    }
}

