/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertEqualsWithLiteralPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssertEqualsWithAssertLiteralIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String assertString;
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length == 2) {
            String argText = args[0].getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        } else {
            String argText = args[1].getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        }
        return IntentionPowerPackBundle.message("replace.assert.equals.with.assert.literal.intention.name", assertString);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        AssertEqualsWithLiteralPredicate assertEqualsWithLiteralPredicate = new AssertEqualsWithLiteralPredicate();
        if (assertEqualsWithLiteralPredicate == null) {
            ReplaceAssertEqualsWithAssertLiteralIntention.$$$reportNull$$$0(0);
        }
        return assertEqualsWithLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        String assertString;
        String actualArgumentText;
        PsiExpression otherArg;
        String argText;
        if (element == null) {
            ReplaceAssertEqualsWithAssertLiteralIntention.$$$reportNull$$$0(1);
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression expression2 = call.getMethodExpression();
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        if (args.length == 2) {
            argText = args[0].getText();
            otherArg = "true".equals(argText) || "false".equals(argText) || "null".equals(argText) ? args[1] : args[0];
            actualArgumentText = otherArg.getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        } else {
            argText = args[1].getText();
            otherArg = "true".equals(argText) || "false".equals(argText) || "null".equals(argText) ? args[2] : args[1];
            actualArgumentText = args[0].getText() + ", " + otherArg.getText();
            assertString = ReplaceAssertEqualsWithAssertLiteralIntention.getAssertString(argText);
        }
        PsiElement qualifier = expression2.getQualifier();
        StringBuilder newExpression = new StringBuilder();
        if (qualifier == null) {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert") && !ImportUtils.addStaticImport("org.junit.Assert", assertString, element)) {
                newExpression.append("org.junit.Assert.");
            }
        } else {
            newExpression.append(qualifier.getText()).append('.');
        }
        newExpression.append(assertString).append('(').append(actualArgumentText).append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)call, newExpression.toString());
    }

    @NonNls
    private static String getAssertString(@NonNls String text2) {
        if ("true".equals(text2)) {
            return "assertTrue";
        }
        if ("false".equals(text2)) {
            return "assertFalse";
        }
        return "assertNull";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/junit/ReplaceAssertEqualsWithAssertLiteralIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/junit/ReplaceAssertEqualsWithAssertLiteralIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

