/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.shift;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.shift.MultiplyByPowerOfTwoPredicate;
import com.siyeh.ipp.shift.ShiftUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceMultiplyWithShiftIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof PsiBinaryExpression) {
            PsiBinaryExpression exp = (PsiBinaryExpression)element;
            PsiJavaToken sign = exp.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            String operatorString = tokenType.equals(JavaTokenType.ASTERISK) ? "<<" : ">>";
            return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", sign.getText(), operatorString);
        }
        PsiAssignmentExpression exp = (PsiAssignmentExpression)element;
        PsiJavaToken sign = exp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        String assignString = tokenType.equals(JavaTokenType.ASTERISKEQ) ? "<<=" : ">>=";
        return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", sign.getText(), assignString);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MultiplyByPowerOfTwoPredicate multiplyByPowerOfTwoPredicate = new MultiplyByPowerOfTwoPredicate();
        if (multiplyByPowerOfTwoPredicate == null) {
            ReplaceMultiplyWithShiftIntention.$$$reportNull$$$0(0);
        }
        return multiplyByPowerOfTwoPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiBinaryExpression) {
            ReplaceMultiplyWithShiftIntention.replaceMultiplyOrDivideWithShift((PsiBinaryExpression)element);
        } else {
            ReplaceMultiplyWithShiftIntention.replaceMultiplyOrDivideAssignWithShiftAssign((PsiAssignmentExpression)element);
        }
    }

    private static void replaceMultiplyOrDivideAssignWithShiftAssign(PsiAssignmentExpression expression2) throws IncorrectOperationException {
        PsiExpression lhs = expression2.getLExpression();
        PsiExpression rhs = expression2.getRExpression();
        IElementType tokenType = expression2.getOperationTokenType();
        String assignString = tokenType.equals(JavaTokenType.ASTERISKEQ) ? "<<=" : ">>=";
        String expString = lhs.getText() + assignString + ShiftUtils.getLogBase2(rhs);
        PsiReplacementUtil.replaceExpression((PsiExpression)expression2, expString);
    }

    private static void replaceMultiplyOrDivideWithShift(PsiBinaryExpression expression2) throws IncorrectOperationException {
        PsiExpression lhs = expression2.getLOperand();
        PsiExpression rhs = expression2.getROperand();
        IElementType tokenType = expression2.getOperationTokenType();
        String operatorString = tokenType.equals(JavaTokenType.ASTERISK) ? "<<" : ">>";
        String lhsText = ParenthesesUtils.getPrecedence(lhs) > 7 ? '(' + lhs.getText() + ')' : lhs.getText();
        String expString = lhsText + operatorString + ShiftUtils.getLogBase2(rhs);
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiExpression && !(parent instanceof PsiParenthesizedExpression) && ParenthesesUtils.getPrecedence((PsiExpression)parent) < 7) {
            expString = '(' + expString + ')';
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)expression2, expString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/shift/ReplaceMultiplyWithShiftIntention", "getElementPredicate"));
    }
}

