/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.varargs.VarargArgumentsPredicate;
import org.jetbrains.annotations.NotNull;

public class WrapVarargArgumentsWithExplicitArrayIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        VarargArgumentsPredicate varargArgumentsPredicate = new VarargArgumentsPredicate();
        if (varargArgumentsPredicate == null) {
            WrapVarargArgumentsWithExplicitArrayIntention.$$$reportNull$$$0(0);
        }
        return varargArgumentsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiCall call;
        if (element == null) {
            WrapVarargArgumentsWithExplicitArrayIntention.$$$reportNull$$$0(1);
        }
        if ((call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCall.class)) == null) {
            return;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        StringBuilder newExpressionText = new StringBuilder("new ");
        PsiParameter[] parameters2 = parameterList.getParameters();
        int varargParameterIndex = parametersCount - 1;
        PsiType componentType = PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)varargParameterIndex, (boolean)true);
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType substitutedType = substitutor.substitute(componentType);
        if (substitutedType instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)substitutedType;
            newExpressionText.append(capturedWildcardType.getLowerBound().getCanonicalText());
        } else {
            newExpressionText.append(substitutedType.getCanonicalText());
        }
        newExpressionText.append("[]{");
        if (arguments.length > varargParameterIndex) {
            PsiExpression argument1 = arguments[varargParameterIndex];
            argument1.delete();
            newExpressionText.append(argument1.getText());
            for (int i = parametersCount; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                newExpressionText.append(',').append(argument.getText());
                argument.delete();
            }
        }
        newExpressionText.append("}");
        Project project2 = element.getProject();
        PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(newExpressionText.toString(), element);
        CodeStyleManager.getInstance((Project)project2).reformat(argumentList.add((PsiElement)newExpression));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/varargs/WrapVarargArgumentsWithExplicitArrayIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/varargs/WrapVarargArgumentsWithExplicitArrayIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

