/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.lang.BracePair;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.intellij.plugins.relaxNG.compact.RncHighlighter;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RngCompactLanguage
extends Language {
    public static final String ID = "RELAX-NG";
    public static final RngCompactLanguage INSTANCE = new RngCompactLanguage();

    private RngCompactLanguage() {
        super(ID, new String[]{"application/relax-ng-compact-syntax"});
    }

    public static class MySyntaxHighlighterFactory
    extends SingleLazyInstanceSyntaxHighlighterFactory {
        @NotNull
        protected SyntaxHighlighter createHighlighter() {
            RncHighlighter rncHighlighter = new RncHighlighter();
            if (rncHighlighter == null) {
                MySyntaxHighlighterFactory.$$$reportNull$$$0(0);
            }
            return rncHighlighter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/compact/RngCompactLanguage$MySyntaxHighlighterFactory", "createHighlighter"));
        }
    }

    public static class MyDocumentationProvider
    implements DocumentationProvider {
        @Nullable
        public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
            return null;
        }

        public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
            return null;
        }

        @Nullable
        public String generateDoc(PsiElement element, PsiElement originalElement) {
            if (element instanceof RncElement) {
                PsiElement comment = element.getPrevSibling();
                while (comment instanceof PsiWhiteSpace) {
                    comment = comment.getPrevSibling();
                }
                if (comment instanceof PsiComment) {
                    StringBuilder sb = new StringBuilder();
                    do {
                        sb.insert(0, EscapeUtil.unescapeText(comment).replaceAll("\n?##?", "") + "<br>");
                    } while ((comment = comment.getPrevSibling()) instanceof PsiComment);
                    if (element instanceof RncDefine) {
                        sb.insert(0, "Define: <b>" + ((RncDefine)element).getName() + "</b><br>");
                    }
                    return sb.toString();
                }
            }
            return null;
        }

        @Nullable
        public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
            return null;
        }

        @Nullable
        public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
            return null;
        }
    }

    public static class MyNamesValidator
    implements NamesValidator {
        public boolean isKeyword(@NotNull String name2, Project project2) {
            if (name2 == null) {
                MyNamesValidator.$$$reportNull$$$0(0);
            }
            return RenameUtil.isKeyword(name2);
        }

        public boolean isIdentifier(@NotNull String name2, Project project2) {
            if (name2 == null) {
                MyNamesValidator.$$$reportNull$$$0(1);
            }
            return RenameUtil.isIdentifier(name2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "org/intellij/plugins/relaxNG/compact/RngCompactLanguage$MyNamesValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isKeyword";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIdentifier";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyPairedBraceMatcher
    implements PairedBraceMatcher {
        private BracePair[] myBracePairs;

        @NotNull
        public BracePair[] getPairs() {
            if (this.myBracePairs == null) {
                this.myBracePairs = new BracePair[]{new BracePair(RncTokenTypes.LBRACE, RncTokenTypes.RBRACE, true), new BracePair(RncTokenTypes.LPAREN, RncTokenTypes.RPAREN, false), new BracePair(RncTokenTypes.LBRACKET, RncTokenTypes.RBRACKET, false)};
            }
            if (this.myBracePairs == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(0);
            }
            return this.myBracePairs;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (lbraceType == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(1);
            }
            return false;
        }

        public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
            return openingBraceOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/compact/RngCompactLanguage$MyPairedBraceMatcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lbraceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPairs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/compact/RngCompactLanguage$MyPairedBraceMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isPairedBracesAllowedBeforeType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyCommenter
    implements Commenter {
        @Nullable
        public String getLineCommentPrefix() {
            return "#";
        }

        @Nullable
        public String getBlockCommentPrefix() {
            return null;
        }

        @Nullable
        public String getBlockCommentSuffix() {
            return null;
        }

        public String getCommentedBlockCommentPrefix() {
            return null;
        }

        public String getCommentedBlockCommentSuffix() {
            return null;
        }
    }
}

